using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Text;
using gov.va.med.vbecs.GUI.controls;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;  // CR2920
//
using gov.va.med.vbecs.BOL;
//
namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// <newpara> Package: VBECS - VistA Blood Establishment Computer System</newpara>
	/// <newpara> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</newpara>
	/// <newpara> Medical Device #: $MEDDEVICENO</newpara>
	/// <newpara> Date Created: 4/30/2002</newpara>
	/// <newpara> Site Name: Hines OIFO </newpara>
	/// <newpara> Developers: Cameron Taylor, John Vrooland</newpara>
	/// <newpara> Description: Select Units for Patient User Interface</newpara>
	/// <newpara> Note: The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</newpara>
	/// </summary>
	public class FrmSelectUnitsForPatient : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		// BACKGROUND AND ORGANIZATION: 
		// The purpose of this use case is to select units for component orders.  If more than one patient has
		// been selected, only the OrderedComponents for one patient are displayed.  When the OK button is 
		// clicked, the components for the next patient will be displayed and so on.
		//
		// For each OrderedComponent, there will be one instance of PatientUnitSelection.  If there are 3 
		// OrderedComponents for the patient, there will be 3 instances of PatientUnitSelection.
		//
		// PatientUnitSelection holds all of the units associated with the OrderedComponent.  It is also 
		// responsible for making sure that the units are valid and generating appropriate error messages.

		#region Variables

		private Patient	_patient;
		/// <summary>
		/// This is an ArrayList of ArrayLists.  The "outer" ArrayList (this one) contains 
		/// ArrayLists of OrderedComponents.  Each "inner" ArrayList has components 
		/// associated with one patient.
		/// </summary>
		private ArrayList _orderedComponentsAllPatients;
		/// <summary>
		/// This contains all of the ordered components for the patient currently being operated on.
		/// </summary>
		private ArrayList _orderedComponentsOnePatient;
		/// <summary>
		/// This contains the node currently being operated on.
		/// </summary>
		private TreeNode _currentlySelectedNode;
		/// <summary>
		/// This contains the PatientUnitSelection currently being operated on.
		/// </summary>
		private BOL.PatientUnitSelection _currentlySelectedPUS;
		/// <summary>
		/// Available units for the patient (pass to UC05 for unit selection).
		/// </summary>
		private DataTable _dtAvailableUnits;
		/// <summary>
		/// Ordered Tests; this UC does nothing with this; just passes it on to UC53
		/// </summary>
		private ArrayList _orderedTests;
		/// <summary>
		/// Components containing units that require a crossmatch; pass this to UC53
		/// </summary>
		private ArrayList _componentsNeedingCrossmatch;
		/// <summary>
		/// This holds units that have already been assigned to a patient
		/// </summary>
		DataTable _dtPreviouslyOrderedUnits;
		/// <summary>
		/// Current date value based on the division time zone
		/// </summary>
		System.DateTime _currentDate;
		/// <summary>
		/// Keeps track of units selected in the current session so they aren't selected
		/// twice for the same patient.
		/// </summary>
		private ArrayList _selectedUnits;
		/// <summary>
		/// Assigning users
		/// </summary>
		private ArrayList _users;
		/// <summary>
		/// The first time the Add Units button is clicked to add units to the order, 
		/// all directed units are to be displayed.  This keeps track of this. 
		/// </summary>
		private ArrayList _alreadyOpened;
		/// <summary>
		/// Holds exception report entries
		/// </summary>
		private ArrayList _bloodUnitSelectionExceptions;
		/// <summary>
		/// Exceptions indicating an order was expired
		/// </summary>
		private ArrayList _expiredOrderExceptions;
		/// <summary>
		/// Indicates if the form is loading.  This indicator prevents the activation
		/// of certain controls
		/// </summary>
		private bool _isLoading;
		/// <summary>
		/// CR2920: Cache object
		/// </summary>
		private Hashtable _orderedComponents;


		private BOL.BloodUnitStatus _lockBloodUnitStatus = null;

		#endregion
	

		#region Form Controls

		private System.Windows.Forms.Button         btnCancel;
		private System.Windows.Forms.Panel          pnlSelectUnits;
		private System.Windows.Forms.Panel          pnlOrders;
		private System.Windows.Forms.Panel          pnlRight;
		private System.Windows.Forms.Splitter       splitter1;
		private System.Windows.Forms.Panel          pnlLeft;
		private System.Windows.Forms.TreeView       tvOrders;
		private System.Windows.Forms.GroupBox       groupBox4;
		private System.Windows.Forms.Timer          timer1;
		private System.Windows.Forms.ImageList      imageList1;
		private System.Windows.Forms.ToolTip        toolTip1;
		private System.Windows.Forms.ContextMenu    contextMenu1;
		private System.Windows.Forms.MenuItem       mnuAddUnit;
		private System.Windows.Forms.PictureBox     pictureBox3;
		private System.Windows.Forms.Panel          pnlOrder;
		private System.Windows.Forms.Panel          pnlOrderHeader;
		private System.Windows.Forms.Label          label2;
		private System.Windows.Forms.PictureBox     pictureBox6;
		private System.Windows.Forms.TextBox        txtReasonRequested;
		private System.Windows.Forms.Label          lblReasonRequested;
		private System.Windows.Forms.TextBox        txtOrderedBy;
		private System.Windows.Forms.Label          lblOrderedBy;
		private System.Windows.Forms.TextBox        txtSpecialRequirements;
		private System.Windows.Forms.Label          lblSpecialRequirements;
		private System.Windows.Forms.TextBox        txtQty;
		private System.Windows.Forms.Label          lblQty;
		private System.Windows.Forms.TextBox        txtDateWanted;
		private System.Windows.Forms.Label          lblDateWanted;
		private System.Windows.Forms.TextBox        txtDateOrdered;
		private System.Windows.Forms.Label          lblDateOrdered;
		private System.Windows.Forms.TextBox        txtComponentClass;
		private System.Windows.Forms.Label          lblComponentClass;
		private System.Windows.Forms.Panel          pnlUnit;
		private System.Windows.Forms.Panel          pnlUnitHeader;
		private System.Windows.Forms.Label          label3;
		private System.Windows.Forms.PictureBox     pictureBox7;
		private System.Windows.Forms.Panel          panel1;
		private System.Windows.Forms.Label          label4;
		private System.Windows.Forms.PictureBox     pictureBox8;
		private System.Windows.Forms.TextBox        txtUrgency;
		private System.Windows.Forms.Label          lblUrgency;
		private System.Windows.Forms.MenuItem       mnuRemoveUnit;
		private System.Windows.Forms.Label          label1;
		private System.Windows.Forms.Label          label5;
		private System.Windows.Forms.Button         btnOrderDetails;
		private System.Windows.Forms.Label          label6;
		private System.ComponentModel.IContainer    components;
		private System.Windows.Forms.CheckBox cbCrossmatchComponent;
		private System.Windows.Forms.TextBox txtComments;
		private System.Windows.Forms.TextBox txtSurgery;
		private System.Windows.Forms.TextBox txtUnitEXMStatus;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnAddUnits;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnDeselect;
		private System.Windows.Forms.Label lblExpires;
		private System.Windows.Forms.TextBox txtExpires;
		private System.Windows.Forms.DateTimePicker dtpAssignedDate;
		private System.Windows.Forms.Label lblSpecimenUid;
		private System.Windows.Forms.Panel pnlSpecimen;
		private System.Windows.Forms.Panel pnlSpecimenTop;
		private System.Windows.Forms.Label lblPatientSpecimen;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.GroupBox grpUnitXMStatus;
		private System.Windows.Forms.GroupBox grpCrossmatchIndicator;
		private System.Windows.Forms.Button btnSpecimenSearch;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbAssignedBy;
		private System.Windows.Forms.Label lblAssignedBy;
		private gov.va.med.vbecs.GUI.controls.BloodUnitDetailsTab bloodUnitDetailsTab1;
		private gov.va.med.vbecs.GUI.controls.BloodUnitSelectorVertical bloodUnitSelectorVertical1;
		private System.Windows.Forms.TextBox txtSpecimenUID;
		private System.Windows.Forms.TextBox txtSpecimenExpires;
		private gov.va.med.vbecs.GUI.controls.PatientSpecimenDisplayPanel patientSpecimenDisplayPanel1;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnSelectUnit;
		private System.Windows.Forms.Panel pnlBottomRight;
		private System.Windows.Forms.Label lblEmergencyMessage;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Label label8;

		#endregion


		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmSelectUnitsForPatient));
			this.btnCancel = new System.Windows.Forms.Button();
			this.pnlSelectUnits = new System.Windows.Forms.Panel();
			this.groupBox4 = new System.Windows.Forms.GroupBox();
			this.pictureBox3 = new System.Windows.Forms.PictureBox();
			this.pnlOrders = new System.Windows.Forms.Panel();
			this.pnlRight = new System.Windows.Forms.Panel();
			this.pnlBottomRight = new System.Windows.Forms.Panel();
			this.pnlOrder = new System.Windows.Forms.Panel();
			this.lblEmergencyMessage = new System.Windows.Forms.Label();
			this.txtComments = new System.Windows.Forms.TextBox();
			this.label5 = new System.Windows.Forms.Label();
			this.txtSurgery = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.txtUrgency = new System.Windows.Forms.TextBox();
			this.lblUrgency = new System.Windows.Forms.Label();
			this.txtReasonRequested = new System.Windows.Forms.TextBox();
			this.lblReasonRequested = new System.Windows.Forms.Label();
			this.txtOrderedBy = new System.Windows.Forms.TextBox();
			this.lblOrderedBy = new System.Windows.Forms.Label();
			this.txtSpecialRequirements = new System.Windows.Forms.TextBox();
			this.lblSpecialRequirements = new System.Windows.Forms.Label();
			this.imageList1 = new System.Windows.Forms.ImageList(this.components);
			this.txtQty = new System.Windows.Forms.TextBox();
			this.lblQty = new System.Windows.Forms.Label();
			this.txtDateWanted = new System.Windows.Forms.TextBox();
			this.lblDateWanted = new System.Windows.Forms.Label();
			this.txtDateOrdered = new System.Windows.Forms.TextBox();
			this.lblDateOrdered = new System.Windows.Forms.Label();
			this.txtComponentClass = new System.Windows.Forms.TextBox();
			this.lblComponentClass = new System.Windows.Forms.Label();
			this.pnlOrderHeader = new System.Windows.Forms.Panel();
			this.label2 = new System.Windows.Forms.Label();
			this.pictureBox6 = new System.Windows.Forms.PictureBox();
			this.btnOrderDetails = new System.Windows.Forms.Button();
			this.btnAddUnits = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.pnlUnit = new System.Windows.Forms.Panel();
			this.bloodUnitSelectorVertical1 = new gov.va.med.vbecs.GUI.controls.BloodUnitSelectorVertical();
			this.bloodUnitDetailsTab1 = new gov.va.med.vbecs.GUI.controls.BloodUnitDetailsTab();
			this.cmbAssignedBy = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.txtExpires = new System.Windows.Forms.TextBox();
			this.lblExpires = new System.Windows.Forms.Label();
			this.pnlUnitHeader = new System.Windows.Forms.Panel();
			this.label3 = new System.Windows.Forms.Label();
			this.pictureBox7 = new System.Windows.Forms.PictureBox();
			this.dtpAssignedDate = new System.Windows.Forms.DateTimePicker();
			this.label6 = new System.Windows.Forms.Label();
			this.lblAssignedBy = new System.Windows.Forms.Label();
			this.btnSelectUnit = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnDeselect = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpUnitXMStatus = new System.Windows.Forms.GroupBox();
			this.txtUnitEXMStatus = new System.Windows.Forms.TextBox();
			this.grpCrossmatchIndicator = new System.Windows.Forms.GroupBox();
			this.txtSpecimenExpires = new System.Windows.Forms.TextBox();
			this.txtSpecimenUID = new System.Windows.Forms.TextBox();
			this.label8 = new System.Windows.Forms.Label();
			this.btnSpecimenSearch = new System.Windows.Forms.Button();
			this.cbCrossmatchComponent = new System.Windows.Forms.CheckBox();
			this.lblSpecimenUid = new System.Windows.Forms.Label();
			this.pnlSpecimen = new System.Windows.Forms.Panel();
			this.pnlSpecimenTop = new System.Windows.Forms.Panel();
			this.lblPatientSpecimen = new System.Windows.Forms.Label();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.patientSpecimenDisplayPanel1 = new gov.va.med.vbecs.GUI.controls.PatientSpecimenDisplayPanel();
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.pnlLeft = new System.Windows.Forms.Panel();
			this.tvOrders = new System.Windows.Forms.TreeView();
			this.contextMenu1 = new System.Windows.Forms.ContextMenu();
			this.mnuAddUnit = new System.Windows.Forms.MenuItem();
			this.mnuRemoveUnit = new System.Windows.Forms.MenuItem();
			this.panel1 = new System.Windows.Forms.Panel();
			this.label4 = new System.Windows.Forms.Label();
			this.pictureBox8 = new System.Windows.Forms.PictureBox();
			this.timer1 = new System.Windows.Forms.Timer(this.components);
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.pnlSelectUnits.SuspendLayout();
			this.groupBox4.SuspendLayout();
			this.pnlOrders.SuspendLayout();
			this.pnlRight.SuspendLayout();
			this.pnlBottomRight.SuspendLayout();
			this.pnlOrder.SuspendLayout();
			this.pnlOrderHeader.SuspendLayout();
			this.pnlUnit.SuspendLayout();
			this.pnlUnitHeader.SuspendLayout();
			this.grpUnitXMStatus.SuspendLayout();
			this.grpCrossmatchIndicator.SuspendLayout();
			this.pnlSpecimen.SuspendLayout();
			this.pnlSpecimenTop.SuspendLayout();
			this.pnlLeft.SuspendLayout();
			this.panel1.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(712, 30);
			this.vbecsLogo1.Title = "Select Units for a Patient";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 465);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(632, 456);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 14;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// pnlSelectUnits
			// 
			this.pnlSelectUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlSelectUnits.Controls.Add(this.groupBox4);
			this.pnlSelectUnits.Controls.Add(this.pnlOrders);
			this.pnlSelectUnits.Location = new System.Drawing.Point(4, 32);
			this.pnlSelectUnits.Name = "pnlSelectUnits";
			this.pnlSelectUnits.Size = new System.Drawing.Size(704, 424);
			this.pnlSelectUnits.TabIndex = 4;
			this.pnlSelectUnits.Visible = false;
			// 
			// groupBox4
			// 
			this.groupBox4.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.groupBox4.Controls.Add(this.pictureBox3);
			this.groupBox4.Location = new System.Drawing.Point(0, -4);
			this.groupBox4.Name = "groupBox4";
			this.groupBox4.Size = new System.Drawing.Size(40, 424);
			this.groupBox4.TabIndex = 38;
			this.groupBox4.TabStop = false;
			// 
			// pictureBox3
			// 
			this.pictureBox3.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox3.Image")));
			this.pictureBox3.Location = new System.Drawing.Point(2, 12);
			this.pictureBox3.Name = "pictureBox3";
			this.pictureBox3.Size = new System.Drawing.Size(32, 32);
			this.pictureBox3.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.pictureBox3.TabIndex = 1;
			this.pictureBox3.TabStop = false;
			// 
			// pnlOrders
			// 
			this.pnlOrders.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlOrders.Controls.Add(this.pnlRight);
			this.pnlOrders.Controls.Add(this.splitter1);
			this.pnlOrders.Controls.Add(this.pnlLeft);
			this.pnlOrders.Location = new System.Drawing.Point(44, 0);
			this.pnlOrders.Name = "pnlOrders";
			this.pnlOrders.Size = new System.Drawing.Size(660, 420);
			this.pnlOrders.TabIndex = 6;
			// 
			// pnlRight
			// 
			this.pnlRight.Controls.Add(this.pnlBottomRight);
			this.pnlRight.Controls.Add(this.pnlSpecimen);
			this.pnlRight.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlRight.Location = new System.Drawing.Point(144, 0);
			this.pnlRight.Name = "pnlRight";
			this.pnlRight.Size = new System.Drawing.Size(516, 420);
			this.pnlRight.TabIndex = 2;
			// 
			// pnlBottomRight
			// 
			this.pnlBottomRight.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.pnlBottomRight.Controls.Add(this.pnlUnit);
			this.pnlBottomRight.Controls.Add(this.pnlOrder);
			this.pnlBottomRight.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlBottomRight.Location = new System.Drawing.Point(0, 72);
			this.pnlBottomRight.Name = "pnlBottomRight";
			this.pnlBottomRight.Size = new System.Drawing.Size(516, 348);
			this.pnlBottomRight.TabIndex = 8;
			// 
			// pnlOrder
			// 
			this.pnlOrder.Controls.Add(this.lblEmergencyMessage);
			this.pnlOrder.Controls.Add(this.txtComments);
			this.pnlOrder.Controls.Add(this.label5);
			this.pnlOrder.Controls.Add(this.txtSurgery);
			this.pnlOrder.Controls.Add(this.label1);
			this.pnlOrder.Controls.Add(this.txtUrgency);
			this.pnlOrder.Controls.Add(this.lblUrgency);
			this.pnlOrder.Controls.Add(this.txtReasonRequested);
			this.pnlOrder.Controls.Add(this.lblReasonRequested);
			this.pnlOrder.Controls.Add(this.txtOrderedBy);
			this.pnlOrder.Controls.Add(this.lblOrderedBy);
			this.pnlOrder.Controls.Add(this.txtSpecialRequirements);
			this.pnlOrder.Controls.Add(this.lblSpecialRequirements);
			this.pnlOrder.Controls.Add(this.txtQty);
			this.pnlOrder.Controls.Add(this.lblQty);
			this.pnlOrder.Controls.Add(this.txtDateWanted);
			this.pnlOrder.Controls.Add(this.lblDateWanted);
			this.pnlOrder.Controls.Add(this.txtDateOrdered);
			this.pnlOrder.Controls.Add(this.lblDateOrdered);
			this.pnlOrder.Controls.Add(this.txtComponentClass);
			this.pnlOrder.Controls.Add(this.lblComponentClass);
			this.pnlOrder.Controls.Add(this.pnlOrderHeader);
			this.pnlOrder.Controls.Add(this.btnAddUnits);
			this.pnlOrder.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlOrder.Location = new System.Drawing.Point(0, 0);
			this.pnlOrder.Name = "pnlOrder";
			this.pnlOrder.Size = new System.Drawing.Size(514, 346);
			this.pnlOrder.TabIndex = 5;
			// 
			// lblEmergencyMessage
			// 
			this.lblEmergencyMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblEmergencyMessage.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lblEmergencyMessage.Font = new System.Drawing.Font("Arial", 10.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblEmergencyMessage.Location = new System.Drawing.Point(4, 250);
			this.lblEmergencyMessage.Name = "lblEmergencyMessage";
			this.lblEmergencyMessage.Size = new System.Drawing.Size(504, 64);
			this.lblEmergencyMessage.TabIndex = 72;
			this.lblEmergencyMessage.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			this.lblEmergencyMessage.Visible = false;
			// 
			// txtComments
			// 
			this.txtComments.AccessibleDescription = "Order Comments";
			this.txtComments.AccessibleName = "Order Comments";
			this.txtComments.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtComments.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtComments.Location = new System.Drawing.Point(132, 88);
			this.txtComments.Name = "txtComments";
			this.txtComments.ReadOnly = true;
			this.txtComments.Size = new System.Drawing.Size(376, 20);
			this.txtComments.TabIndex = 6;
			this.txtComments.Text = "";
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(4, 88);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(132, 20);
			this.label5.TabIndex = 63;
			this.label5.Text = "Order Comments";
			this.label5.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtSurgery
			// 
			this.txtSurgery.AccessibleDescription = "Pre Op Surgery Name";
			this.txtSurgery.AccessibleName = "Pre Op Surgery Name";
			this.txtSurgery.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSurgery.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtSurgery.Location = new System.Drawing.Point(132, 184);
			this.txtSurgery.Name = "txtSurgery";
			this.txtSurgery.ReadOnly = true;
			this.txtSurgery.Size = new System.Drawing.Size(376, 20);
			this.txtSurgery.TabIndex = 11;
			this.txtSurgery.Text = "";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(4, 184);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(120, 20);
			this.label1.TabIndex = 61;
			this.label1.Text = "Pre-Op Surgery Name";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtUrgency
			// 
			this.txtUrgency.AccessibleDescription = "Urgency";
			this.txtUrgency.AccessibleName = "Urgency";
			this.txtUrgency.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtUrgency.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtUrgency.Location = new System.Drawing.Point(132, 112);
			this.txtUrgency.Name = "txtUrgency";
			this.txtUrgency.ReadOnly = true;
			this.txtUrgency.Size = new System.Drawing.Size(376, 20);
			this.txtUrgency.TabIndex = 7;
			this.txtUrgency.Text = "";
			// 
			// lblUrgency
			// 
			this.lblUrgency.Location = new System.Drawing.Point(4, 112);
			this.lblUrgency.Name = "lblUrgency";
			this.lblUrgency.Size = new System.Drawing.Size(132, 20);
			this.lblUrgency.TabIndex = 58;
			this.lblUrgency.Text = "Urgency";
			this.lblUrgency.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtReasonRequested
			// 
			this.txtReasonRequested.AccessibleDescription = "Reason Requested";
			this.txtReasonRequested.AccessibleName = "Reason Requested";
			this.txtReasonRequested.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtReasonRequested.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtReasonRequested.Location = new System.Drawing.Point(132, 208);
			this.txtReasonRequested.Multiline = true;
			this.txtReasonRequested.Name = "txtReasonRequested";
			this.txtReasonRequested.ReadOnly = true;
			this.txtReasonRequested.Size = new System.Drawing.Size(376, 36);
			this.txtReasonRequested.TabIndex = 12;
			this.txtReasonRequested.Text = "";
			// 
			// lblReasonRequested
			// 
			this.lblReasonRequested.Location = new System.Drawing.Point(4, 208);
			this.lblReasonRequested.Name = "lblReasonRequested";
			this.lblReasonRequested.Size = new System.Drawing.Size(132, 20);
			this.lblReasonRequested.TabIndex = 55;
			this.lblReasonRequested.Text = "Reason Requested";
			this.lblReasonRequested.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtOrderedBy
			// 
			this.txtOrderedBy.AccessibleDescription = "Ordered By";
			this.txtOrderedBy.AccessibleName = "Ordered By";
			this.txtOrderedBy.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOrderedBy.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtOrderedBy.Location = new System.Drawing.Point(132, 160);
			this.txtOrderedBy.Name = "txtOrderedBy";
			this.txtOrderedBy.ReadOnly = true;
			this.txtOrderedBy.Size = new System.Drawing.Size(376, 20);
			this.txtOrderedBy.TabIndex = 10;
			this.txtOrderedBy.Text = "";
			// 
			// lblOrderedBy
			// 
			this.lblOrderedBy.Location = new System.Drawing.Point(4, 160);
			this.lblOrderedBy.Name = "lblOrderedBy";
			this.lblOrderedBy.Size = new System.Drawing.Size(136, 20);
			this.lblOrderedBy.TabIndex = 54;
			this.lblOrderedBy.Text = "Ordered By";
			this.lblOrderedBy.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtSpecialRequirements
			// 
			this.txtSpecialRequirements.AccessibleDescription = "Additional Requirements";
			this.txtSpecialRequirements.AccessibleName = "Additional Requirements";
			this.txtSpecialRequirements.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSpecialRequirements.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtSpecialRequirements.Location = new System.Drawing.Point(132, 48);
			this.txtSpecialRequirements.Multiline = true;
			this.txtSpecialRequirements.Name = "txtSpecialRequirements";
			this.txtSpecialRequirements.ReadOnly = true;
			this.txtSpecialRequirements.Size = new System.Drawing.Size(376, 36);
			this.txtSpecialRequirements.TabIndex = 5;
			this.txtSpecialRequirements.Text = "";
			// 
			// lblSpecialRequirements
			// 
			this.lblSpecialRequirements.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.lblSpecialRequirements.ImageIndex = 1;
			this.lblSpecialRequirements.ImageList = this.imageList1;
			this.lblSpecialRequirements.Location = new System.Drawing.Point(4, 48);
			this.lblSpecialRequirements.Name = "lblSpecialRequirements";
			this.lblSpecialRequirements.Size = new System.Drawing.Size(132, 20);
			this.lblSpecialRequirements.TabIndex = 53;
			this.lblSpecialRequirements.Text = "Additional Requirements";
			this.lblSpecialRequirements.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// imageList1
			// 
			this.imageList1.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
			this.imageList1.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// txtQty
			// 
			this.txtQty.AccessibleDescription = "Quantity";
			this.txtQty.AccessibleName = "Quantity";
			this.txtQty.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtQty.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtQty.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtQty.Location = new System.Drawing.Point(452, 24);
			this.txtQty.Name = "txtQty";
			this.txtQty.ReadOnly = true;
			this.txtQty.Size = new System.Drawing.Size(56, 20);
			this.txtQty.TabIndex = 4;
			this.txtQty.Text = "";
			// 
			// lblQty
			// 
			this.lblQty.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblQty.Location = new System.Drawing.Point(408, 24);
			this.lblQty.Name = "lblQty";
			this.lblQty.Size = new System.Drawing.Size(48, 20);
			this.lblQty.TabIndex = 52;
			this.lblQty.Text = "Quantity";
			this.lblQty.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtDateWanted
			// 
			this.txtDateWanted.AccessibleDescription = "Date Wanted";
			this.txtDateWanted.AccessibleName = "Date Wanted";
			this.txtDateWanted.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtDateWanted.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtDateWanted.Location = new System.Drawing.Point(372, 136);
			this.txtDateWanted.Name = "txtDateWanted";
			this.txtDateWanted.ReadOnly = true;
			this.txtDateWanted.Size = new System.Drawing.Size(136, 20);
			this.txtDateWanted.TabIndex = 9;
			this.txtDateWanted.Text = "";
			// 
			// lblDateWanted
			// 
			this.lblDateWanted.Location = new System.Drawing.Point(300, 136);
			this.lblDateWanted.Name = "lblDateWanted";
			this.lblDateWanted.Size = new System.Drawing.Size(72, 20);
			this.lblDateWanted.TabIndex = 51;
			this.lblDateWanted.Text = "Date Wanted";
			this.lblDateWanted.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtDateOrdered
			// 
			this.txtDateOrdered.AccessibleDescription = "Date Received";
			this.txtDateOrdered.AccessibleName = "Date Received";
			this.txtDateOrdered.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtDateOrdered.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtDateOrdered.Location = new System.Drawing.Point(132, 136);
			this.txtDateOrdered.Name = "txtDateOrdered";
			this.txtDateOrdered.ReadOnly = true;
			this.txtDateOrdered.Size = new System.Drawing.Size(136, 20);
			this.txtDateOrdered.TabIndex = 8;
			this.txtDateOrdered.Text = "";
			// 
			// lblDateOrdered
			// 
			this.lblDateOrdered.Location = new System.Drawing.Point(4, 136);
			this.lblDateOrdered.Name = "lblDateOrdered";
			this.lblDateOrdered.Size = new System.Drawing.Size(132, 20);
			this.lblDateOrdered.TabIndex = 50;
			this.lblDateOrdered.Text = "Date Received";
			this.lblDateOrdered.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtComponentClass
			// 
			this.txtComponentClass.AccessibleDescription = "Component Ordered";
			this.txtComponentClass.AccessibleName = "Component Ordered";
			this.txtComponentClass.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtComponentClass.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtComponentClass.Location = new System.Drawing.Point(132, 24);
			this.txtComponentClass.Name = "txtComponentClass";
			this.txtComponentClass.ReadOnly = true;
			this.txtComponentClass.Size = new System.Drawing.Size(268, 20);
			this.txtComponentClass.TabIndex = 3;
			this.txtComponentClass.Text = "";
			// 
			// lblComponentClass
			// 
			this.lblComponentClass.Location = new System.Drawing.Point(4, 24);
			this.lblComponentClass.Name = "lblComponentClass";
			this.lblComponentClass.Size = new System.Drawing.Size(132, 20);
			this.lblComponentClass.TabIndex = 49;
			this.lblComponentClass.Text = "Component Ordered";
			this.lblComponentClass.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pnlOrderHeader
			// 
			this.pnlOrderHeader.BackColor = System.Drawing.SystemColors.ActiveCaption;
			this.pnlOrderHeader.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.pnlOrderHeader.Controls.Add(this.label2);
			this.pnlOrderHeader.Controls.Add(this.pictureBox6);
			this.pnlOrderHeader.Controls.Add(this.btnOrderDetails);
			this.pnlOrderHeader.Dock = System.Windows.Forms.DockStyle.Top;
			this.pnlOrderHeader.Location = new System.Drawing.Point(0, 0);
			this.pnlOrderHeader.Name = "pnlOrderHeader";
			this.pnlOrderHeader.Size = new System.Drawing.Size(514, 20);
			this.pnlOrderHeader.TabIndex = 1;
			// 
			// label2
			// 
			this.label2.ForeColor = System.Drawing.SystemColors.ActiveCaptionText;
			this.label2.Location = new System.Drawing.Point(24, 0);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(120, 20);
			this.label2.TabIndex = 1;
			this.label2.Text = "Component Order";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pictureBox6
			// 
			this.pictureBox6.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox6.Image")));
			this.pictureBox6.Location = new System.Drawing.Point(4, 2);
			this.pictureBox6.Name = "pictureBox6";
			this.pictureBox6.Size = new System.Drawing.Size(16, 16);
			this.pictureBox6.TabIndex = 0;
			this.pictureBox6.TabStop = false;
			// 
			// btnOrderDetails
			// 
			this.btnOrderDetails.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOrderDetails.BackColor = System.Drawing.SystemColors.Control;
			this.btnOrderDetails.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnOrderDetails.Image = ((System.Drawing.Image)(resources.GetObject("btnOrderDetails.Image")));
			this.btnOrderDetails.Location = new System.Drawing.Point(490, -2);
			this.btnOrderDetails.Name = "btnOrderDetails";
			this.btnOrderDetails.Size = new System.Drawing.Size(24, 20);
			this.btnOrderDetails.TabIndex = 2;
			this.toolTip1.SetToolTip(this.btnOrderDetails, "Order Details");
			this.btnOrderDetails.Click += new System.EventHandler(this.btnOrderDetails_Click);
			// 
			// btnAddUnits
			// 
			this.btnAddUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnAddUnits.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnAddUnits.Image = ((System.Drawing.Image)(resources.GetObject("btnAddUnits.Image")));
			this.btnAddUnits.Location = new System.Drawing.Point(362, 320);
			this.btnAddUnits.Name = "btnAddUnits";
			this.btnAddUnits.Size = new System.Drawing.Size(150, 23);
			this.btnAddUnits.TabIndex = 13;
			this.btnAddUnits.Click += new System.EventHandler(this.btnAddUnits_Click);
			// 
			// pnlUnit
			// 
			this.pnlUnit.Controls.Add(this.bloodUnitSelectorVertical1);
			this.pnlUnit.Controls.Add(this.bloodUnitDetailsTab1);
			this.pnlUnit.Controls.Add(this.cmbAssignedBy);
			this.pnlUnit.Controls.Add(this.txtExpires);
			this.pnlUnit.Controls.Add(this.lblExpires);
			this.pnlUnit.Controls.Add(this.pnlUnitHeader);
			this.pnlUnit.Controls.Add(this.dtpAssignedDate);
			this.pnlUnit.Controls.Add(this.label6);
			this.pnlUnit.Controls.Add(this.lblAssignedBy);
			this.pnlUnit.Controls.Add(this.btnSelectUnit);
			this.pnlUnit.Controls.Add(this.btnDeselect);
			this.pnlUnit.Controls.Add(this.grpUnitXMStatus);
			this.pnlUnit.Controls.Add(this.grpCrossmatchIndicator);
			this.pnlUnit.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlUnit.Location = new System.Drawing.Point(0, 0);
			this.pnlUnit.Name = "pnlUnit";
			this.pnlUnit.Size = new System.Drawing.Size(514, 346);
			this.pnlUnit.TabIndex = 6;
			// 
			// bloodUnitSelectorVertical1
			// 
			this.bloodUnitSelectorVertical1.AccessibleDescription = "Blood Unit Selector";
			this.bloodUnitSelectorVertical1.AccessibleName = "Blood Unit Selector";
			this.bloodUnitSelectorVertical1.AdditionalSearchCriteria = gov.va.med.vbecs.Common.AdditionalBloodUnitSearchCriteria.None;
			this.bloodUnitSelectorVertical1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.bloodUnitSelectorVertical1.Location = new System.Drawing.Point(4, 20);
			this.bloodUnitSelectorVertical1.Name = "bloodUnitSelectorVertical1";
			this.bloodUnitSelectorVertical1.Size = new System.Drawing.Size(258, 304);
			this.bloodUnitSelectorVertical1.TabIndex = 0;
			this.bloodUnitSelectorVertical1.SearchBtnClick += new System.EventHandler(this.bloodUnitSelectorVertical1_SearchClick);
			this.bloodUnitSelectorVertical1.UnitUpdated += new System.EventHandler(this.bloodUnitSelectorVertical1_UnitUpdated);
			this.bloodUnitSelectorVertical1.ClearBtnClick += new System.EventHandler(this.bloodUnitSelectorVertical1_ClearBtnClick);
			// 
			// bloodUnitDetailsTab1
			// 
			this.bloodUnitDetailsTab1.AccessibleDescription = "Blood Unit Details";
			this.bloodUnitDetailsTab1.AccessibleName = "Blood Unit Details";
			this.bloodUnitDetailsTab1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.bloodUnitDetailsTab1.BloodUnit = null;
			this.bloodUnitDetailsTab1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.bloodUnitDetailsTab1.Location = new System.Drawing.Point(268, 24);
			this.bloodUnitDetailsTab1.Name = "bloodUnitDetailsTab1";
			this.bloodUnitDetailsTab1.Size = new System.Drawing.Size(240, 143);
			this.bloodUnitDetailsTab1.TabIndex = 1;
			// 
			// cmbAssignedBy
			// 
			this.cmbAssignedBy.AccessibleDescription = "Assigned By";
			this.cmbAssignedBy.AccessibleName = "Assigned By";
			this.cmbAssignedBy.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbAssignedBy.Enabled = false;
			this.cmbAssignedBy.Interval = 500;
			this.cmbAssignedBy.Location = new System.Drawing.Point(356, 291);
			this.cmbAssignedBy.Name = "cmbAssignedBy";
			this.cmbAssignedBy.Size = new System.Drawing.Size(140, 22);
			this.cmbAssignedBy.TabIndex = 5;
			this.cmbAssignedBy.SelectedIndexChanged += new System.EventHandler(this.cmbAssignedBy_SelectedIndexChanged);
			// 
			// txtExpires
			// 
			this.txtExpires.AccessibleDescription = "Unit Expiration";
			this.txtExpires.AccessibleName = "Unit Expiration";
			this.txtExpires.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtExpires.Location = new System.Drawing.Point(356, 171);
			this.txtExpires.Name = "txtExpires";
			this.txtExpires.ReadOnly = true;
			this.txtExpires.Size = new System.Drawing.Size(140, 20);
			this.txtExpires.TabIndex = 2;
			this.txtExpires.Text = "";
			// 
			// lblExpires
			// 
			this.lblExpires.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblExpires.Location = new System.Drawing.Point(272, 171);
			this.lblExpires.Name = "lblExpires";
			this.lblExpires.Size = new System.Drawing.Size(80, 20);
			this.lblExpires.TabIndex = 63;
			this.lblExpires.Text = "Unit Expiration";
			this.lblExpires.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pnlUnitHeader
			// 
			this.pnlUnitHeader.BackColor = System.Drawing.SystemColors.ActiveCaption;
			this.pnlUnitHeader.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.pnlUnitHeader.Controls.Add(this.label3);
			this.pnlUnitHeader.Controls.Add(this.pictureBox7);
			this.pnlUnitHeader.Dock = System.Windows.Forms.DockStyle.Top;
			this.pnlUnitHeader.Location = new System.Drawing.Point(0, 0);
			this.pnlUnitHeader.Name = "pnlUnitHeader";
			this.pnlUnitHeader.Size = new System.Drawing.Size(514, 20);
			this.pnlUnitHeader.TabIndex = 1;
			// 
			// label3
			// 
			this.label3.ForeColor = System.Drawing.SystemColors.ActiveCaptionText;
			this.label3.Location = new System.Drawing.Point(24, 2);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(100, 16);
			this.label3.TabIndex = 1;
			this.label3.Text = "Unit";
			this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pictureBox7
			// 
			this.pictureBox7.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox7.Image")));
			this.pictureBox7.Location = new System.Drawing.Point(4, 2);
			this.pictureBox7.Name = "pictureBox7";
			this.pictureBox7.Size = new System.Drawing.Size(16, 16);
			this.pictureBox7.TabIndex = 0;
			this.pictureBox7.TabStop = false;
			// 
			// dtpAssignedDate
			// 
			this.dtpAssignedDate.AccessibleDescription = "Assigned Date";
			this.dtpAssignedDate.AccessibleName = "Assigned Date";
			this.dtpAssignedDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpAssignedDate.CustomFormat = "MM/dd/yyyy HH:mm";
			this.dtpAssignedDate.Enabled = false;
			this.dtpAssignedDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpAssignedDate.Location = new System.Drawing.Point(356, 267);
			this.dtpAssignedDate.Name = "dtpAssignedDate";
			this.dtpAssignedDate.Size = new System.Drawing.Size(140, 20);
			this.dtpAssignedDate.TabIndex = 4;
			this.dtpAssignedDate.Leave += new System.EventHandler(this.dtpAssignedDate_Leave);
			this.dtpAssignedDate.ValueChanged += new System.EventHandler(this.dtpAssignedDate_ValueChanged);
			// 
			// label6
			// 
			this.label6.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.label6.Location = new System.Drawing.Point(272, 267);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(88, 20);
			this.label6.TabIndex = 1;
			this.label6.Text = "Assigned Date*";
			this.label6.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblAssignedBy
			// 
			this.lblAssignedBy.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.lblAssignedBy.Location = new System.Drawing.Point(272, 291);
			this.lblAssignedBy.Name = "lblAssignedBy";
			this.lblAssignedBy.Size = new System.Drawing.Size(88, 20);
			this.lblAssignedBy.TabIndex = 70;
			this.lblAssignedBy.Text = "Assigned By*";
			this.lblAssignedBy.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnSelectUnit
			// 
			this.btnSelectUnit.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSelectUnit.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSelectUnit.Image = ((System.Drawing.Image)(resources.GetObject("btnSelectUnit.Image")));
			this.btnSelectUnit.Location = new System.Drawing.Point(360, 320);
			this.btnSelectUnit.Name = "btnSelectUnit";
			this.btnSelectUnit.Size = new System.Drawing.Size(152, 23);
			this.btnSelectUnit.TabIndex = 6;
			this.btnSelectUnit.Click += new System.EventHandler(this.bloodUnitSelectorVertical1_SelectBtnClick);
			// 
			// btnDeselect
			// 
			this.btnDeselect.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnDeselect.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnDeselect.Image = ((System.Drawing.Image)(resources.GetObject("btnDeselect.Image")));
			this.btnDeselect.Location = new System.Drawing.Point(360, 320);
			this.btnDeselect.Name = "btnDeselect";
			this.btnDeselect.Size = new System.Drawing.Size(152, 23);
			this.btnDeselect.TabIndex = 62;
			this.btnDeselect.Visible = false;
			this.btnDeselect.Click += new System.EventHandler(this.btnDeselect_Click);
			// 
			// grpUnitXMStatus
			// 
			this.grpUnitXMStatus.AccessibleDescription = "eXM Status";
			this.grpUnitXMStatus.AccessibleName = "eXM Status";
			this.grpUnitXMStatus.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpUnitXMStatus.Controls.Add(this.txtUnitEXMStatus);
			this.grpUnitXMStatus.Location = new System.Drawing.Point(268, 195);
			this.grpUnitXMStatus.Name = "grpUnitXMStatus";
			this.grpUnitXMStatus.Size = new System.Drawing.Size(240, 68);
			this.grpUnitXMStatus.TabIndex = 5;
			this.grpUnitXMStatus.TabStop = false;
			this.grpUnitXMStatus.Text = "eXM Status";
			// 
			// txtUnitEXMStatus
			// 
			this.txtUnitEXMStatus.AccessibleDescription = "Electronic Crossmatch Status";
			this.txtUnitEXMStatus.AccessibleName = "Electronic Crossmatch Status";
			this.txtUnitEXMStatus.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtUnitEXMStatus.Location = new System.Drawing.Point(8, 16);
			this.txtUnitEXMStatus.Multiline = true;
			this.txtUnitEXMStatus.Name = "txtUnitEXMStatus";
			this.txtUnitEXMStatus.ReadOnly = true;
			this.txtUnitEXMStatus.Size = new System.Drawing.Size(220, 44);
			this.txtUnitEXMStatus.TabIndex = 3;
			this.txtUnitEXMStatus.Text = "";
			// 
			// grpCrossmatchIndicator
			// 
			this.grpCrossmatchIndicator.AccessibleDescription = "Crossmatch Indicator";
			this.grpCrossmatchIndicator.AccessibleName = "Crossmatch Indicator";
			this.grpCrossmatchIndicator.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpCrossmatchIndicator.Controls.Add(this.txtSpecimenExpires);
			this.grpCrossmatchIndicator.Controls.Add(this.txtSpecimenUID);
			this.grpCrossmatchIndicator.Controls.Add(this.label8);
			this.grpCrossmatchIndicator.Controls.Add(this.btnSpecimenSearch);
			this.grpCrossmatchIndicator.Controls.Add(this.cbCrossmatchComponent);
			this.grpCrossmatchIndicator.Controls.Add(this.lblSpecimenUid);
			this.grpCrossmatchIndicator.Location = new System.Drawing.Point(268, 195);
			this.grpCrossmatchIndicator.Name = "grpCrossmatchIndicator";
			this.grpCrossmatchIndicator.Size = new System.Drawing.Size(240, 68);
			this.grpCrossmatchIndicator.TabIndex = 68;
			this.grpCrossmatchIndicator.TabStop = false;
			this.grpCrossmatchIndicator.Visible = false;
			// 
			// txtSpecimenExpires
			// 
			this.txtSpecimenExpires.AccessibleDescription = "Expires";
			this.txtSpecimenExpires.AccessibleName = "Expires";
			this.txtSpecimenExpires.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSpecimenExpires.Location = new System.Drawing.Point(88, 44);
			this.txtSpecimenExpires.Name = "txtSpecimenExpires";
			this.txtSpecimenExpires.ReadOnly = true;
			this.txtSpecimenExpires.Size = new System.Drawing.Size(128, 20);
			this.txtSpecimenExpires.TabIndex = 8;
			this.txtSpecimenExpires.Text = "";
			// 
			// txtSpecimenUID
			// 
			this.txtSpecimenUID.AccessibleDescription = "Specimen UID";
			this.txtSpecimenUID.AccessibleName = "Specimen UID";
			this.txtSpecimenUID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSpecimenUID.Location = new System.Drawing.Point(88, 20);
			this.txtSpecimenUID.Name = "txtSpecimenUID";
			this.txtSpecimenUID.ReadOnly = true;
			this.txtSpecimenUID.Size = new System.Drawing.Size(108, 20);
			this.txtSpecimenUID.TabIndex = 7;
			this.txtSpecimenUID.Text = "";
			this.txtSpecimenUID.TextChanged += new System.EventHandler(this.txtSpecimenUID_TextChanged);
			// 
			// label8
			// 
			this.label8.Location = new System.Drawing.Point(8, 44);
			this.label8.Name = "label8";
			this.label8.Size = new System.Drawing.Size(84, 20);
			this.label8.TabIndex = 6;
			this.label8.Text = "Expires";
			this.label8.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnSpecimenSearch
			// 
			this.btnSpecimenSearch.AccessibleDescription = "find";
			this.btnSpecimenSearch.AccessibleName = "find";
			this.btnSpecimenSearch.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSpecimenSearch.Enabled = false;
			this.btnSpecimenSearch.Font = new System.Drawing.Font("Arial", 6F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSpecimenSearch.Location = new System.Drawing.Point(196, 20);
			this.btnSpecimenSearch.Name = "btnSpecimenSearch";
			this.btnSpecimenSearch.Size = new System.Drawing.Size(28, 20);
			this.btnSpecimenSearch.TabIndex = 5;
			this.btnSpecimenSearch.Text = "find";
			this.btnSpecimenSearch.Click += new System.EventHandler(this.btnSpecimenSearch_Click);
			// 
			// cbCrossmatchComponent
			// 
			this.cbCrossmatchComponent.AccessibleDescription = "Optional Component Crossmatch";
			this.cbCrossmatchComponent.AccessibleName = "Optional Component Crossmatch";
			this.cbCrossmatchComponent.Location = new System.Drawing.Point(4, 0);
			this.cbCrossmatchComponent.Name = "cbCrossmatchComponent";
			this.cbCrossmatchComponent.Size = new System.Drawing.Size(192, 16);
			this.cbCrossmatchComponent.TabIndex = 0;
			this.cbCrossmatchComponent.Text = "O&ptional Component Crossmatch";
			this.cbCrossmatchComponent.Click += new System.EventHandler(this.cbCrossmatchComponent_Click);
			// 
			// lblSpecimenUid
			// 
			this.lblSpecimenUid.Location = new System.Drawing.Point(8, 20);
			this.lblSpecimenUid.Name = "lblSpecimenUid";
			this.lblSpecimenUid.Size = new System.Drawing.Size(84, 20);
			this.lblSpecimenUid.TabIndex = 1;
			this.lblSpecimenUid.Text = "Specimen UID*";
			this.lblSpecimenUid.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pnlSpecimen
			// 
			this.pnlSpecimen.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.pnlSpecimen.Controls.Add(this.pnlSpecimenTop);
			this.pnlSpecimen.Controls.Add(this.patientSpecimenDisplayPanel1);
			this.pnlSpecimen.Dock = System.Windows.Forms.DockStyle.Top;
			this.pnlSpecimen.Location = new System.Drawing.Point(0, 0);
			this.pnlSpecimen.Name = "pnlSpecimen";
			this.pnlSpecimen.Size = new System.Drawing.Size(516, 72);
			this.pnlSpecimen.TabIndex = 7;
			// 
			// pnlSpecimenTop
			// 
			this.pnlSpecimenTop.BackColor = System.Drawing.SystemColors.ActiveCaption;
			this.pnlSpecimenTop.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.pnlSpecimenTop.Controls.Add(this.lblPatientSpecimen);
			this.pnlSpecimenTop.Controls.Add(this.pictureBox1);
			this.pnlSpecimenTop.Dock = System.Windows.Forms.DockStyle.Top;
			this.pnlSpecimenTop.Location = new System.Drawing.Point(0, 0);
			this.pnlSpecimenTop.Name = "pnlSpecimenTop";
			this.pnlSpecimenTop.Size = new System.Drawing.Size(514, 20);
			this.pnlSpecimenTop.TabIndex = 2;
			// 
			// lblPatientSpecimen
			// 
			this.lblPatientSpecimen.ForeColor = System.Drawing.SystemColors.ActiveCaptionText;
			this.lblPatientSpecimen.Location = new System.Drawing.Point(24, 2);
			this.lblPatientSpecimen.Name = "lblPatientSpecimen";
			this.lblPatientSpecimen.Size = new System.Drawing.Size(100, 16);
			this.lblPatientSpecimen.TabIndex = 1;
			this.lblPatientSpecimen.Text = "Patient Specimen";
			this.lblPatientSpecimen.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 2);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(16, 16);
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// patientSpecimenDisplayPanel1
			// 
			this.patientSpecimenDisplayPanel1.AboRh = "";
			this.patientSpecimenDisplayPanel1.AccessibleDescription = "Patient Specimen";
			this.patientSpecimenDisplayPanel1.AccessibleName = "Patient Specimen";
			this.patientSpecimenDisplayPanel1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.patientSpecimenDisplayPanel1.EnabledBloodAvailButton = false;
			this.patientSpecimenDisplayPanel1.EnabledMedicationButton = false;
			this.patientSpecimenDisplayPanel1.EnabledRecentOrdersButton = false;
			this.patientSpecimenDisplayPanel1.EnabledRecentTransfusionsIssuesButton = false;
			this.patientSpecimenDisplayPanel1.EnabledSIAndTRButton = false;
			this.patientSpecimenDisplayPanel1.EnabledTransfusionReactionHistoryButton = false;
			this.patientSpecimenDisplayPanel1.Expires = "";
			this.patientSpecimenDisplayPanel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.patientSpecimenDisplayPanel1.Location = new System.Drawing.Point(-48, 12);
			this.patientSpecimenDisplayPanel1.Name = "patientSpecimenDisplayPanel1";
			this.patientSpecimenDisplayPanel1.Patient = null;
			this.patientSpecimenDisplayPanel1.PatientID = "";
			this.patientSpecimenDisplayPanel1.PatientName = "";
			this.patientSpecimenDisplayPanel1.Size = new System.Drawing.Size(566, 60);
			this.patientSpecimenDisplayPanel1.Specimen = null;
			this.patientSpecimenDisplayPanel1.SpecimenID = "";
			this.patientSpecimenDisplayPanel1.TabIndex = 1;
			// 
			// splitter1
			// 
			this.splitter1.BackColor = System.Drawing.SystemColors.ControlDark;
			this.splitter1.Location = new System.Drawing.Point(138, 0);
			this.splitter1.MinExtra = 400;
			this.splitter1.MinSize = 100;
			this.splitter1.Name = "splitter1";
			this.splitter1.Size = new System.Drawing.Size(6, 420);
			this.splitter1.TabIndex = 1;
			this.splitter1.TabStop = false;
			// 
			// pnlLeft
			// 
			this.pnlLeft.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.pnlLeft.Controls.Add(this.tvOrders);
			this.pnlLeft.Controls.Add(this.panel1);
			this.pnlLeft.Dock = System.Windows.Forms.DockStyle.Left;
			this.pnlLeft.Location = new System.Drawing.Point(0, 0);
			this.pnlLeft.Name = "pnlLeft";
			this.pnlLeft.Size = new System.Drawing.Size(138, 420);
			this.pnlLeft.TabIndex = 0;
			// 
			// tvOrders
			// 
			this.tvOrders.AccessibleDescription = "Orders";
			this.tvOrders.AccessibleName = "Orders";
			this.tvOrders.BorderStyle = System.Windows.Forms.BorderStyle.None;
			this.tvOrders.ContextMenu = this.contextMenu1;
			this.tvOrders.Dock = System.Windows.Forms.DockStyle.Fill;
			this.tvOrders.HideSelection = false;
			this.tvOrders.ImageList = this.imageList1;
			this.tvOrders.Location = new System.Drawing.Point(0, 20);
			this.tvOrders.Name = "tvOrders";
			this.tvOrders.Nodes.AddRange(new System.Windows.Forms.TreeNode[] {
																				 new System.Windows.Forms.TreeNode("RBC x4", 3, 3, new System.Windows.Forms.TreeNode[] {
																																										   new System.Windows.Forms.TreeNode("BB12121, 04210", 4, 4),
																																										   new System.Windows.Forms.TreeNode("BB21212, 04210", 4, 4)}),
																				 new System.Windows.Forms.TreeNode("FFP x2", 3, 3, new System.Windows.Forms.TreeNode[] {
																																										   new System.Windows.Forms.TreeNode("BB331133, 18611", 4, 4)})});
			this.tvOrders.Size = new System.Drawing.Size(136, 398);
			this.tvOrders.TabIndex = 0;
			this.tvOrders.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.tvOrders_AfterSelect);
			// 
			// contextMenu1
			// 
			this.contextMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						 this.mnuAddUnit,
																						 this.mnuRemoveUnit});
			// 
			// mnuAddUnit
			// 
			this.mnuAddUnit.Enabled = false;
			this.mnuAddUnit.Index = 0;
			this.mnuAddUnit.Text = "Add &Unit to Component Order";
			// 
			// mnuRemoveUnit
			// 
			this.mnuRemoveUnit.Enabled = false;
			this.mnuRemoveUnit.Index = 1;
			this.mnuRemoveUnit.Text = "&De-Select Unit from Component Order";
			// 
			// panel1
			// 
			this.panel1.BackColor = System.Drawing.SystemColors.ActiveCaption;
			this.panel1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.panel1.Controls.Add(this.label4);
			this.panel1.Controls.Add(this.pictureBox8);
			this.panel1.Dock = System.Windows.Forms.DockStyle.Top;
			this.panel1.Location = new System.Drawing.Point(0, 0);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(136, 20);
			this.panel1.TabIndex = 2;
			// 
			// label4
			// 
			this.label4.ForeColor = System.Drawing.SystemColors.ActiveCaptionText;
			this.label4.Location = new System.Drawing.Point(24, 0);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(124, 20);
			this.label4.TabIndex = 1;
			this.label4.Text = "Order Group";
			this.label4.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pictureBox8
			// 
			this.pictureBox8.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox8.Image")));
			this.pictureBox8.Location = new System.Drawing.Point(4, 2);
			this.pictureBox8.Name = "pictureBox8";
			this.pictureBox8.Size = new System.Drawing.Size(16, 16);
			this.pictureBox8.TabIndex = 0;
			this.pictureBox8.TabStop = false;
			// 
			// timer1
			// 
			this.timer1.Enabled = true;
			this.timer1.Interval = 300;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(552, 456);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 13;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// FrmSelectUnitsForPatient
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(712, 481);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.pnlSelectUnits);
			this.hlphelpChm.SetHelpKeyword(this, "Select_Units.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(650, 500);
			this.Name = "FrmSelectUnitsForPatient";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Select Units for a Patient";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmSelectUnitsForPatient_KeyDownSpeakMessage);
			this.Closed += new System.EventHandler(this.FrmSelectUnitsForPatient_Closed);
			this.Controls.SetChildIndex(this.pnlSelectUnits, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.pnlSelectUnits.ResumeLayout(false);
			this.groupBox4.ResumeLayout(false);
			this.pnlOrders.ResumeLayout(false);
			this.pnlRight.ResumeLayout(false);
			this.pnlBottomRight.ResumeLayout(false);
			this.pnlOrder.ResumeLayout(false);
			this.pnlOrderHeader.ResumeLayout(false);
			this.pnlUnit.ResumeLayout(false);
			this.pnlUnitHeader.ResumeLayout(false);
			this.grpUnitXMStatus.ResumeLayout(false);
			this.grpCrossmatchIndicator.ResumeLayout(false);
			this.pnlSpecimen.ResumeLayout(false);
			this.pnlSpecimenTop.ResumeLayout(false);
			this.pnlLeft.ResumeLayout(false);
			this.panel1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion
        

		#region Constructors/Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="orderedComponents"></param>
		/// <param name="orderedTests"></param>
		/// <param name="fromUC40"></param>
		/// <param name="expiredOrderExceptions"></param>
		public FrmSelectUnitsForPatient(ArrayList orderedComponents, ArrayList orderedTests, bool fromUC40, ArrayList expiredOrderExceptions)
		{
			this.LockController.LockFunction = Common.LockFunctions.UC003SelectUnitsForPatient;

			_isLoading = true;

			_orderedTests = orderedTests;

			this.InitializeComponent();
			SetComponentProperties(fromUC40);

			// Ordered Components can potentially come in from multiple patients, but we only 
			// want to handle one patient at a time.  The next patient will be displayed when
			// the OK button is hit.
			this.GroupOrderedComponentsByPatient(orderedComponents);

			System.Collections.ArrayList lockGuids = new ArrayList();
			System.Collections.ArrayList tmpArray = (ArrayList)this._orderedComponentsAllPatients[0];

			foreach (BOL.OrderedTest tmpOT in orderedTests)
			{
				lockGuids.Add(tmpOT.OrderedTestGuid);
				ArrayList alOUGuids = BOL.OrderedUnit.GetOrderedUnitsForSpecimen(tmpOT.Specimen.SpecimenGuid);
				foreach(System.Guid ouGuid in alOUGuids)
				{
					lockGuids.Add(ouGuid);
				}
			}

			foreach(BOL.OrderedComponent tmpOC in tmpArray)
			{
				System.Data.DataTable dtOU = BOL.OrderedUnit.GetOrderedUnitByComponent(tmpOC.OrderedComponentGuid, Common.LogonUser.LogonUserDivisionCode);
				foreach(System.Data.DataRow drOU in dtOU.Rows)
				{
					//CR 2758 - If blocks added to prevent extra unecessary record locking
					//          Check to see if any previous units have already been crossmatched, if they have, don't lock them, since there's no
					//          action that can be taken on them (they're basically read-only) - displayed on the tvOrders.
					BOL.OrderedComponent oc = new BOL.OrderedComponent(drOU);
					if ( (bool) drOU[Common.VbecsTables.OrderedUnit.CrossmatchRequiredIndicator] == true)		
					{
						// don't include orders that don't have a specimen
						if (drOU.IsNull(Common.VbecsTables.OrderedUnit.CrossmatchResultCode) && oc.SpecimenIdentified)  // CR3114
						{
							lockGuids.Add((System.Guid)drOU[Common.VbecsTables.OrderedUnit.OrderedUnitGuid]);
							//CR2043 - Add the BloodUnitStatus lock on FormLoad event
							lockGuids.Add((System.Guid)drOU[Common.VbecsTables.BloodUnitStatus.BloodUnitStatusGuid]);
						}
					}
				}
			}

			if (!this.SetLocks((System.Guid[])lockGuids.ToArray(typeof(System.Guid))))
			{
				this.DialogResult = DialogResult.Abort;
				return;
			}

			PopulateForm();	
						
			//Setting the dirty variable to true to signal that the form 
			//has been altered
			this.IsDirty=true;
			_bloodUnitSelectionExceptions = new ArrayList();
			_alreadyOpened = new ArrayList();
			_selectedUnits = new ArrayList();
			_expiredOrderExceptions = expiredOrderExceptions;

			_isLoading = false;
		}

		#endregion


		#region Methods


		/// <summary>
		/// Add units to the TreeView when multiple units were chosen from UC5 (via the BloodUnitSelector)
		/// </summary>
		/// <param name="dtUnits"></param>
		private void AddUnitsToTreeView(DataTable dtUnits)
		{
			foreach(DataRow dr in dtUnits.Rows)
			{
                if (!this.DidLocksExpire)   //CR3480 - bleh, not happy but simplest way without big rewrite
                {
                    // Add the object instead of the DataRow to be consistent with 
                    // way units are added from the BloodUnitSelector.
                    BOL.BloodUnit bloodUnit = new BOL.BloodUnit(dr);
                    this.AddUnit(bloodUnit, true);
                }
			}			
		}


		/// <summary>
		/// SetComponentProperties
		/// </summary>
		/// <param name="fromUC40"></param>
		private void SetComponentProperties(bool fromUC40)
		{
			// set blood selector properties
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC003.FrmSelectUnitsForPatient());
			//
			_orderedComponentsAllPatients = new ArrayList();

			if (fromUC40)
			{
				this.pnlOrder.Visible = false;
				this.pnlUnit.Visible = true;
			}
			else
			{
				this.pnlSelectUnits.Visible = true;
				this.pnlUnit.Visible = true;
			}

			this.btnAddUnits.Text = "&Add Units";
			this.btnDeselect.Text = "&Remove Unit";
			this.btnSelectUnit.Text = "&Select Unit";
			
			_componentsNeedingCrossmatch = new ArrayList();

			//set custom date and time format
			this.dtpAssignedDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
			//set current date value based on the division time zone
			_currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpAssignedDate.Value = _currentDate;
			
			// assigning tech
			foreach( BOL.VbecsUser user in (_users = BOL.VbecsUser.GetActiveDivisionUsers( Common.LogonUser.LogonUserDivisionCode )) )
				this.cmbAssignedBy.Items.Add( user.UserName );
			this.cmbAssignedBy.SelectedItem = ThisUser.UserName;
			// assigned date
			this.dtpAssignedDate.MaxDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
		}


		/// <summary>
		/// Populates the UI with patient orders!
		/// </summary>
		private void PopulateForm()
		{
			_orderedComponentsOnePatient = (ArrayList) _orderedComponentsAllPatients[0];
			
			// populate the TreeView
			this.tvOrders.Nodes.Clear();
			BOL.OrderedComponent orderedComponent = null;
			for (int i=0; i<_orderedComponentsOnePatient.Count; i++)
			{
				orderedComponent = (BOL.OrderedComponent) _orderedComponentsOnePatient[i];

				TreeNode treeNode = new TreeNode(orderedComponent.ComponentOrdered.BloodComponentName + " x" + orderedComponent.Quantity,3,3);
					
				BOL.PatientUnitSelection pUS = new BOL.PatientUnitSelection(orderedComponent, ThisUser);

				pUS.SetInitialBrokenRules(this.Name);

				pUS.SelectedUnitsCollection.SelectMessagesEvent += new BOL.PatientUnitSelection.SelectedUnits.SelectMessagesEventHandler(ShowValidationMessages);
				treeNode.Tag = pUS;

				this.tvOrders.Nodes.Add(treeNode);

				// If the component has units already associated with it, display them too
				DataTable dtAlreadyOrderedUnits = pUS.AlreadyOrderedUnits;

				if (i > 0)
				{
					foreach (DataRow dr in dtAlreadyOrderedUnits.Rows)
					{
						_dtPreviouslyOrderedUnits.Rows.Add(dr.ItemArray);
					}
				}
				else
				{
					_dtPreviouslyOrderedUnits = dtAlreadyOrderedUnits;
				}

				bool alreadyAdded = false;
				
				if (_orderedComponents == null)	_orderedComponents = new Hashtable(); //CR2920

				foreach (DataRow dr in dtAlreadyOrderedUnits.Rows)
				{
					// Even if the OrderedComponent was added in a previous session, we need to 
					// pass it to UC40 if the crossmatch has not been done.  Check alreadyAdded to 
					// make sure duplicate OCs aren't added.
					
					
					// CR2920: start
					Guid ocGuid = (System.Guid) dr[TABLE.OrderedComponent.OrderedComponentGuid];

					BOL.OrderedComponent oc;
					if (_orderedComponents.ContainsKey(ocGuid))
					{
						oc = (BOL.OrderedComponent) _orderedComponents[ocGuid];
					}
					else
					{
						oc = new BOL.OrderedComponent(dr);
						_orderedComponents.Add(ocGuid, oc);	
					}
					// CR2920: end


					if ( (bool) dr[Common.VbecsTables.OrderedUnit.CrossmatchRequiredIndicator] == true)
					{
						// don't include orders that don't have a specimen
						if (dr.IsNull(Common.VbecsTables.OrderedUnit.CrossmatchResultCode) && oc.SpecimenIdentified)  // CR3114
						{
							if (!alreadyAdded)	
							{
								_componentsNeedingCrossmatch.Add(oc);
								alreadyAdded = true;
							}
						}
						else
						{
							string xmResultCode = new OrderedUnit(dr).CurrentCrossmatchResultCode;

							if (xmResultCode == Common.Utility.GetCrossmatchResultStringFromEnum(Common.CrossmatchResult.CompatibleSafeToTransfuse) ||
								xmResultCode == Common.Utility.GetCrossmatchResultStringFromEnum(Common.CrossmatchResult.CompatibleEXM) ||
								xmResultCode == Common.Utility.GetCrossmatchResultStringFromEnum(Common.CrossmatchResult.Inconclusive))
							{
								pUS.SelectedUnitsCollection.AlreadySelectedUnitsCrossmatchedSuccessfully = pUS.SelectedUnitsCollection.AlreadySelectedUnitsCrossmatchedSuccessfully + 1;   
							}
						}
					}

					BOL.BloodUnit bu = new BOL.BloodUnit( (Guid) dr[Common.VbecsTables.BloodUnit.BloodUnitGuid] );

					TreeNode unitNode = null;

					string status = ", Assigned";
					if (bu.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.CrossmatchedAssigned) status = ", Crossmatched";
					else if (bu.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Issued) status = ", Issued";
					else if (bu.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Transfused) status = ", Transfused";

					if (bu.BarcodeType == Common.BarcodeType.ISBT128)
					{
						unitNode = new TreeNode(bu.EyeReadableUnitId + ", " + bu.ProductCode + bu.DonationType.DonationTypeCode.ToString().Trim() + bu.UnitDivisionId +  status,4,4);
					}
					else
					{
						unitNode = new TreeNode(bu.EyeReadableUnitId + ", " + bu.ProductCode + status,4,4);
					}
					
					unitNode.Tag = bu.BloodUnitGuid;
					treeNode.Nodes.Add(unitNode);
				}

				// Set the first node to the default Ordered Component selection
				if (i==0)
				{
					_currentlySelectedNode = treeNode;
					_currentlySelectedPUS = (BOL.PatientUnitSelection) treeNode.Tag;
					//Setting the IsDirtyChanged event to fire the SetDirtyFlag function
					//Signaling that the form has been changed.
					_currentlySelectedPUS.IsDirtyChanged += new System.EventHandler(this.SetDirtyFlag);
					this.SetEmergencyIssue(_currentlySelectedPUS.IsEmergencyIssue);

					_currentlySelectedNode.ExpandAll();
				}
			}

            //CR 3554
            if (orderedComponent == null)
                throw new ApplicationException("Ordered component is not found"); //Carrie123

			_patient = orderedComponent.Patient;	
			this.patientSpecimenDisplayPanel1.Patient = _patient;
			if (orderedComponent.SpecimenIdentified)  // CR3114
			{
				this.patientSpecimenDisplayPanel1.SpecimenID = orderedComponent.GetSpecimen().SpecimenUid;  // CR3114
				this.patientSpecimenDisplayPanel1.Expires = Common.VBECSDateTime.FormatDateTimeString(orderedComponent.GetSpecimen().SpecimenExpirationDate);  // CR3114
			}
			
			// Call to BR_3.17
			this.txtUnitEXMStatus.Text = _currentlySelectedPUS.GetDivisionAndPatientEXMStatus(ThisUser.CurrentDivisionRole.Division);

			// Force AfterSelect method to fire.   This will populate the form.
			this.tvOrders.SelectedNode = _currentlySelectedNode;
		}


		/// <summary>
		/// Sets the form to indicate emergency issue.  The form title as well as "Add" button 
		/// text will change.
		/// </summary>
		private void SetEmergencyIssue(bool emergencyIssue)
		{
			if (emergencyIssue)
			{
				this.lblEmergencyMessage.Enabled = true;
				this.lblEmergencyMessage.Visible = true;
				this.lblEmergencyMessage.Text = Common.StrRes.InfoMsg.UC003.EmergencyIssueMessage().ResString + "\n" + _currentlySelectedPUS.EmergencyIssueReason;

				this.Text = "VBECS - Select Units for a Patient EMERGENCY ISSUE";
				this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
				this.lblEmergencyMessage.Enabled = true;
			}
			else
			{
				this.lblEmergencyMessage.Enabled = false;
				this.lblEmergencyMessage.Visible = false;

				this.Text = "VBECS - Select Units for a Patient";
				this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			}
		}


		/// <summary>
		/// There are many business rules that must be applied when a unit is selected.  If any of these 
		/// business rules fail or result in an override situation, an event is generated.   This method is 
		/// called when the event is fired.  It's purpose is to generate and display the validation message.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ShowValidationMessages(object sender, BOL.PatientUnitSelection.SelectedUnits.SelectEventArgs e)
		{
			// The blood unit that was selected:
			Guid bloodUnitGuid = e.BloodUnitGuid;
			bool beep = false;

			string comment = string.Empty;

			DataTable dtOrderedUnitComments = BOL.OrderedUnitComment.InitializeBlankOrderedUnitCommentTable();
			StringBuilder messagesRequiringComment = new StringBuilder();
			StringBuilder messagesInfoOnly = new StringBuilder();

			bool stopProcessing = false;
			bool clearMessages = false;

			for (int i=0; i<_currentlySelectedPUS.ValidationMessages.Count; i++)
			{		
				BOL.PatientUnitSelectionMessage pUSM = (BOL.PatientUnitSelectionMessage) _currentlySelectedPUS.ValidationMessages[i];
				if (pUSM.Beep) beep = true;
				switch (pUSM.Message)
				{
                    //CR 3260
                    // These are informational messages only.
                    case Common.UC03UnitSelectErrorMessages.BR311NoABORhResults:
                    case Common.UC03UnitSelectErrorMessages.BR312UnitFrozen:
                    case Common.UC03UnitSelectErrorMessages.BR323UnitIncompatible:
                        messagesInfoOnly.Append(pUSM.MessageText + "\n");
                        break;

                    // These are messages that require a user's comment
                    case Common.UC03UnitSelectErrorMessages.BR306Override:
                    case Common.UC03UnitSelectErrorMessages.BR319UnitExpiredOverride:
                    case Common.UC03UnitSelectErrorMessages.BR321:
                    case Common.UC03UnitSelectErrorMessages.BR321Female:
                    case Common.UC03UnitSelectErrorMessages.BR332CMVNegRequiredOverride:
                    // CR3206
                    case Common.UC03UnitSelectErrorMessages.BR332SickleCellNegRequiredOverride:
                    case Common.UC03UnitSelectErrorMessages.BR332SickleCellAndCMVNegRequiredOverride:

                    case Common.UC03UnitSelectErrorMessages.BR334RestrictiveUnits:
                    case Common.UC03UnitSelectErrorMessages.BR339BiohazardousWarningIndicator:
                        messagesRequiringComment.Append(pUSM.MessageText + "\n");
                        break;

                    // All others
					default:
						// No override: 
						//  316, No ABO/Rh confirmation
						//  319, Unit already selected for this patient
						//  319, Unit not in same division
						//  313, Unit already crossmatched for this patient
						//  341, Only autologous WB (is there any other kind?) if patient ABO/Rh unknown
						//  333, Invalid product type
						//  343, Unit is quarantined
						//  345, Unit is on Pending Outgoing Shipment list
						//  346, Unit is restricted for a different patient
						// 
						// No override due to security level
						//	306, Antigen or antibody positive test
						//  308, Anti-D
						//  310, ABO ncompatible
						//  319, Unit is expired

						if (!pUSM.OverRideable)
						{
							string message = string.Concat("VBECS - Not selectable, Unit: ", pUSM.EyeReabableUnitID, "\n", pUSM.MessageText);

							if (pUSM.Beep) GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(message));
							else GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.Common.Dynamic(message));

							//CR2043 - Can't take the unit, so unlock it
							this.ReleaseLocks(e.BloodUnitStatusGuid);
							stopProcessing = true;
						}
						else
						{
							// BRs:
							//  314, Transfusion requirements
							messagesInfoOnly.Append(pUSM.MessageText + "\n");
						}
						break;
				}
				if (stopProcessing == true) 
				{
					break;
				}
				else if (i == _currentlySelectedPUS.ValidationMessages.Count-1)
				{
					StringBuilder warningMessage = new StringBuilder();
					if (messagesRequiringComment.Length > 0) 
					{
						warningMessage.Append("The following warning(s) require a comment: \n");
						warningMessage.Append(messagesRequiringComment.ToString() + "\n");
					}
					if (messagesInfoOnly.Length > 0)
					{
						warningMessage.Append("The following warning(s) are informational: \n");
						warningMessage.Append(messagesInfoOnly.ToString() + "\n");
					}
					warningMessage.Append("Do you wish to proceed with the selection of unit (" + pUSM.EyeReabableUnitID + "):?");

					if (beep) Common.Utility.MessageBeep();
					DialogResult result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.Dynamic(warningMessage.ToString()));
					if (result == DialogResult.Yes)
					{
						if (messagesRequiringComment.Length > 0)
						{
							//DlgSelectUnitOverride dlg = new DlgSelectUnitOverride(pUSM);
							string message = "Unit: " + pUSM.EyeReabableUnitID + "\n Additional information is required to process this override.  Please select a comment to confirm override.";
							DlgOverrideComment dlg = new DlgOverrideComment("Confirm Selection", message, "US", Common.StrRes.HelpFiles.UC003.DlgSelectUnitOverride().ResString);

                            dlg.ShowDialogFromLockedParent(this, false);
                            if (dlg.DidLocksExpire) return;

							if (dlg.DialogResult == DialogResult.OK) 
							{
								//comment = dlg.CommentText;
								comment = dlg.Comment;
								clearMessages = true;
							}
							else
							{
								//CR2043 - They didn't provide a comment, so release the lock because the unit isn't going further
								this.ReleaseLocks(e.BloodUnitStatusGuid);
							}
						}
						else
						{
							//No comment was needed, dont unlock
							clearMessages = true;
						}
					}
					else
					{
						//CR2043- Unlock the record - because they cancelled the original Validation Message Window
						this.ReleaseLocks(e.BloodUnitStatusGuid);
					}
				}
			}

			if (clearMessages == true)  // indicates user has chosen to proceed with selection of unit despite problems
			{
				//generating exceptions for exception report
				for (int i=0; i<_currentlySelectedPUS.ValidationMessages.Count; i++)
				{		
					BOL.PatientUnitSelectionMessage pUSM = (BOL.PatientUnitSelectionMessage) _currentlySelectedPUS.ValidationMessages[i];

					Common.ExceptionType exType;
					switch (pUSM.Message)
					{
						case Common.UC03UnitSelectErrorMessages.BR306Override:
							exType = Common.ExceptionType.Antigen_positive_unit_selected;
							break;
						case Common.UC03UnitSelectErrorMessages.BR310Override:
							exType = Common.ExceptionType.ABO_incompatible_unit_selected;
							break;
						case Common.UC03UnitSelectErrorMessages.BR319UnitExpiredOverride:
							exType = Common.ExceptionType.Selected_expired_unit;
							break;
						case Common.UC03UnitSelectErrorMessages.BR321:
						case Common.UC03UnitSelectErrorMessages.BR321Female:
							exType = Common.ExceptionType.Rh_positive_units_selected;
							break;
						case Common.UC03UnitSelectErrorMessages.BR332CMVNegRequiredOverride:
                        case Common.UC03UnitSelectErrorMessages.BR332SickleCellNegRequiredOverride: //CR3260
                        case Common.UC03UnitSelectErrorMessages.BR332SickleCellAndCMVNegRequiredOverride: //CR3260
							exType = Common.ExceptionType.Transfusion_requirement_incompatible_unit_selected;
							break;
						case Common.UC03UnitSelectErrorMessages.BR334RestrictiveUnits:
							exType = Common.ExceptionType.Less_restrictive_unit_selected;
							break;
						case Common.UC03UnitSelectErrorMessages.BR339BiohazardousWarningIndicator:
							exType = Common.ExceptionType.Biohazardous_unit_selected;
							break;
						default:
							exType = Common.ExceptionType.Unknown;
							break;
					}

					if (exType != Common.ExceptionType.Unknown)
					{
						BOL.ExceptionReport exRep = new BOL.ExceptionReport(exType, comment, Common.LogonUser.LogonUserName);
						exRep.GenerateExceptionUnitSelection(bloodUnitGuid, _patient, this.dtpAssignedDate.Value, "");
						_bloodUnitSelectionExceptions.Add(exRep);
					}
				}

				_currentlySelectedPUS.ValidationMessages.Clear();
			}
		}


		/// <summary>
		/// AddOrderedUnitComment
		/// </summary>
		/// <param name="commentText"></param>
		/// <param name="commentGuid"></param>
		private void AddOrderedUnitComment(string commentText, Guid commentGuid)
		{
			DataRow dr = _currentlySelectedPUS.SelectedUnitsCollection.TempOrderedUnitComments.NewRow();
			dr[Common.VbecsTables.OrderedUnitComment.OrderedUnitCommentGuid] = Guid.NewGuid();
			dr[Common.VbecsTables.OrderedUnitComment.OrderedUnitCommentText] = (string) commentText;
			dr[Common.VbecsTables.OrderedUnitComment.CannedCommentGuid]	= (Guid) commentGuid;
			dr[Common.VbecsTables.OrderedUnitComment.LastUpdateUser] = Common.LogonUser.LogonUserName;
		
			_currentlySelectedPUS.SelectedUnitsCollection.TempOrderedUnitComments.Rows.Add(dr);
		}
		

		/// <summary>
		/// Group Ordered Components by patient to facilitate their display
		/// </summary>
		/// <param name="orderedComponents"></param>
		private void GroupOrderedComponentsByPatient(ArrayList orderedComponents)
		{
			Guid patientGUID;
			
			for (int i=0; i<orderedComponents.Count; i++)
			{
				ArrayList orderedComponentsForOnePatient = new ArrayList();

				if (orderedComponents.Count > 0)
				{
					BOL.OrderedComponent orderedComponent = (BOL.OrderedComponent) orderedComponents[0];
					patientGUID = orderedComponent.PatientGuid;

					orderedComponentsForOnePatient.Add(orderedComponent);
					orderedComponents.Remove(orderedComponent);
					i--;
					// Loop again and get the rest of the Component Orders for this patient
					for (int j=0; j<orderedComponents.Count; j++)
					{
						BOL.OrderedComponent orderedComponent2 = (BOL.OrderedComponent) orderedComponents[j];
						if (orderedComponent2.PatientGuid.Equals(patientGUID))
						{
							orderedComponentsForOnePatient.Add(orderedComponent2);
							orderedComponents.Remove(orderedComponent2);
							j--;
							i--;
						}
					}
					_orderedComponentsAllPatients.Add(orderedComponentsForOnePatient);
				}
			}
		}


		private void SetTimeAndTech(Guid bloodUnitGuid)
		{
			if (_currentlySelectedPUS.AlreadySelectedInPreviousSession(this.bloodUnitSelectorVertical1.SelectedBloodUnit.BloodUnitGuid))
			{
				// get from datarows...
				DataRow [] dtRow = _currentlySelectedPUS.AlreadyOrderedUnits.Select(Common.VbecsTables.OrderedUnit.BloodUnitGuid + " = '" + bloodUnitGuid + "'");
				
				this.dtpAssignedDate.Value = (DateTime) dtRow[0][Common.VbecsTables.OrderedUnit.SelectedDate];
				BOL.VbecsUser user = new BOL.VbecsUser(dtRow[0][Common.VbecsTables.OrderedUnit.SelectedTechId].ToString());
				this.cmbAssignedBy.SelectedItem = user.UserName;

				this.dtpAssignedDate.Enabled = false;
				this.cmbAssignedBy.Enabled = false;

				// Set select/ deselect buttons
				this.btnSelectUnit.Visible = false;
				this.btnSelectUnit.EnabledButton = false;

				this.btnDeselect.Visible = true;
				this.btnDeselect.EnabledButton = false;
				this.toolTip1.SetToolTip(this.btnDeselect, Common.StrRes.InfoMsg.UC003.NoDeselect().ResString);
			}
				// unit added in this session
			else if (_currentlySelectedPUS.SelectedUnitsCollection.Contains(this.bloodUnitSelectorVertical1.SelectedBloodUnit.BloodUnitGuid))
			{
				this.dtpAssignedDate.Value = (DateTime) _currentlySelectedPUS.SelectedUnitsCollection.GetOrderedUnit(bloodUnitGuid)[Common.VbecsTables.OrderedUnit.SelectedDate];
				BOL.VbecsUser user = new BOL.VbecsUser( _currentlySelectedPUS.SelectedUnitsCollection.GetOrderedUnit(bloodUnitGuid)[Common.VbecsTables.OrderedUnit.SelectedTechId].ToString());
				this.cmbAssignedBy.SelectedItem = user.UserName;

				this.dtpAssignedDate.Enabled = true;
				this.cmbAssignedBy.Enabled = true;

				// Set select/ deselect buttons
				this.btnSelectUnit.Visible = false;
				this.btnSelectUnit.EnabledButton = false;

				this.btnDeselect.Visible = true;
				this.btnDeselect.EnabledButton = true;
				this.toolTip1.SetToolTip(this.btnDeselect, String.Empty);
			}
				// new unit
			else 
			{
				// Set to current date/time, user
				this.dtpAssignedDate.Value = this.dtpAssignedDate.MaxDate;
				this.cmbAssignedBy.SelectedItem = ThisUser.UserName;

				this.dtpAssignedDate.Enabled = true;
				this.cmbAssignedBy.Enabled = true;

				// Set select/ deselect buttons
				this.btnSelectUnit.Visible = true;
				this.btnSelectUnit.EnabledButton = true;

				this.btnDeselect.Visible = false;
				this.btnDeselect.EnabledButton = false;
			}
		}

		/// <summary>
		/// Adds unit to the collection
		/// </summary>
		/// <param name="bloodUnit"></param>
		/// <param name="fromPicklist"></param>
		public void AddUnit(BOL.BloodUnit bloodUnit, bool fromPicklist)
		{
			// Need to adjust MaxDate to account for any time that has passed between form opening and selection
			this.dtpAssignedDate.MaxDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();			

			// Make sure this unit hasn't been added to another OrderedComponent in the group:
			if (_selectedUnits.Contains(bloodUnit.BloodUnitGuid))
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC003.AlreadySelectedForThisPatient());
				return;
			}

			//CR2043 - BloodUnitStatus lock is needed (not BloodUnit)
			if (this.SetLocks(bloodUnit.BloodUnitStatus.BloodUnitStatusGuid))
			{
				bool validUnit = false;
				if (fromPicklist) validUnit = _currentlySelectedPUS.SelectedUnitsCollection.AddUnit(bloodUnit, this.dtpAssignedDate.MaxDate, Common.LogonUser.LogonUserName, ThisUser.CurrentDivisionRole.Role.UserRoleId);
				else validUnit = _currentlySelectedPUS.SelectedUnitsCollection.AddUnit(bloodUnit, this.dtpAssignedDate.Value, ((BOL.VbecsUser) _users[this.cmbAssignedBy.SelectedIndex]).UserNTLoginID, ThisUser.CurrentDivisionRole.Role.UserRoleId);
				
				if (validUnit)
				{
					//CR1887 - Lohse 05/23/2006
					//Need to build the "displayed" product code differently based on label type. Use FullProductCode
					TreeNode treeNode = new TreeNode(bloodUnit.EyeReadableUnitId + ", " + bloodUnit.FullProductCode,4,4);
					treeNode.Tag = bloodUnit.BloodUnitGuid;

					if (_currentlySelectedNode.Parent == null)
					{
						_currentlySelectedNode.Nodes.Add(treeNode);
					}
					else
					{
						_currentlySelectedNode.Parent.Nodes.Add(treeNode);
					}
					_selectedUnits.Add(bloodUnit.BloodUnitGuid);
				}
				else
				{
					//CR2043 - Release the BloodUnitStatusGuid
					this.ReleaseLocks(bloodUnit.BloodUnitStatus.BloodUnitStatusGuid);
				}
			}
			this.tvOrders.ExpandAll();
		}

		/// <summary>
		/// Gets the BloodUnitStatusGuid for a given BloodUnit
		/// Added for CR2043 - To caculate the BloodUnitStatusGuid in a central location and hopefully save DB trips
		/// </summary>
		/// <param name="bloodUnitGuid"></param>
		/// <returns></returns>
		private System.Guid GetBloodUnitStatusGuid(System.Guid bloodUnitGuid)
		{
			if (this._lockBloodUnitStatus == null)
			{
				this._lockBloodUnitStatus = new BOL.BloodUnitStatus(bloodUnitGuid);
			}
			else
			{
				if (this._lockBloodUnitStatus.BloodUnitGuid != bloodUnitGuid)
				{
					this._lockBloodUnitStatus = new BOL.BloodUnitStatus(bloodUnitGuid);
				}
			}
			return(this._lockBloodUnitStatus.BloodUnitStatusGuid);
		}
				
		private void PrintTags(BOL.BloodUnit bloodUnit)
		{			
			if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC003.PrintTags(bloodUnit.EyeReadableUnitId)) == DialogResult.Yes)
			{
				bool cautionTagPrintedSuccessfully = false;
				// Caution tag
				CautionTag cautionTag = new CautionTag(bloodUnit, _patient, ThisUser, true);
				try
				{
					cautionTagPrintedSuccessfully = cautionTag.Print(Common.Print.CautionTag);
				}
				catch (System.Net.Sockets.SocketException)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC003.CautionTagPrinterNotAvailable());
				}

				// Only print Blood Transfusion Record Form if there is at least 1 printer
				// installed on the server (CR 2320).
				if (Common.Utility.GetPrintersInstalledOnServer().GetLength(0)>0)
				{
					// BTRF
					System.Drawing.Printing.PrinterSettings settings = new System.Drawing.Printing.PrinterSettings();
                    ReportDataSource reportSourceMain = new ReportDataSource();
                    reportSourceMain.Name = "BTRFDataSet";
                    reportSourceMain.Value = cautionTag.GetBtrfDataSet().Tables[0];

                    Assembly assembly = Assembly.LoadFrom("Reports.dll");
                    Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodTransfusionRecordForm.BloodTransfusionRecordForm.rdlc");

                    LocalReport report = new LocalReport();
                    report.DataSources.Add(reportSourceMain);
                    report.LoadReportDefinition(stream);
                    report.DisplayName = "BTRF";

				    using (var reportPrinter = new BOL.VbecsReportPrinter(settings, false, report))
				    {
				        reportPrinter.Print();
				    }
				}
				else
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC003.ReportPrinterNotAvailable());
				}

				if (cautionTagPrintedSuccessfully)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.PrintSuccess());
				}
				else
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC043.PrinterProblem());
				}
			}
		}

		/// <summary>
		/// Free up resources
		/// </summary>
		private void DestructComponent()
		{
			this.components.Dispose();
			this.btnCancel.Dispose();
			this.pnlSelectUnits.Dispose();
			this.groupBox4.Dispose();
			this.pictureBox3.Dispose();
			this.pnlOrders.Dispose();
			this.pnlRight.Dispose();
			this.pnlBottomRight.Dispose();
			this.pnlUnit.Dispose();
			this.bloodUnitSelectorVertical1.Dispose();
			this.bloodUnitDetailsTab1.Dispose();
			this.cmbAssignedBy.Dispose();
			this.txtExpires.Dispose();
			this.lblExpires.Dispose();
			this.pnlUnitHeader.Dispose();
			this.label3.Dispose();
			this.pictureBox7.Dispose();
			this.dtpAssignedDate.Dispose();
			this.label6.Dispose();
			this.lblAssignedBy.Dispose();
			this.btnSelectUnit.Dispose();
			this.btnDeselect.Dispose();
			this.grpUnitXMStatus.Dispose();
			this.txtUnitEXMStatus.Dispose();
			this.grpCrossmatchIndicator.Dispose();
			this.txtSpecimenExpires.Dispose();
			this.txtSpecimenUID.Dispose();
			this.label8.Dispose();
			this.btnSpecimenSearch.Dispose();
			this.cbCrossmatchComponent.Dispose();
			this.lblSpecimenUid.Dispose();
			this.pnlOrder.Dispose();
			this.lblEmergencyMessage.Dispose();
			this.txtComments.Dispose();
			this.label5.Dispose();
			this.txtSurgery.Dispose();
			this.label1.Dispose();
			this.txtUrgency.Dispose();
			this.lblUrgency.Dispose();
			this.txtReasonRequested.Dispose();
			this.lblReasonRequested.Dispose();
			this.txtOrderedBy.Dispose();
			this.lblOrderedBy.Dispose();
			this.txtSpecialRequirements.Dispose();
			this.lblSpecialRequirements.Dispose();
			this.imageList1.Dispose();
			this.txtQty.Dispose();
			this.lblQty.Dispose();
			this.txtDateWanted.Dispose();
			this.lblDateWanted.Dispose();
			this.txtDateOrdered.Dispose();
			this.lblDateOrdered.Dispose();
			this.txtComponentClass.Dispose();
			this.lblComponentClass.Dispose();
			this.pnlOrderHeader.Dispose();
			this.label2.Dispose();
			this.pictureBox6.Dispose();
			this.btnOrderDetails.Dispose();
			this.btnAddUnits.Dispose();
			this.pnlSpecimen.Dispose();
			this.pnlSpecimenTop.Dispose();
			this.lblPatientSpecimen.Dispose();
			this.pictureBox1.Dispose();
			this.patientSpecimenDisplayPanel1.Dispose();
			this.splitter1.Dispose();
			this.pnlLeft.Dispose();
			this.tvOrders.Dispose();
			this.contextMenu1.Dispose();
			this.mnuAddUnit.Dispose();
			this.mnuRemoveUnit.Dispose();
			this.panel1.Dispose();
			this.label4.Dispose();
			this.pictureBox8.Dispose();
			this.timer1.Dispose();
			this.toolTip1.Dispose();
			this.btnOK.Dispose();
		}

		#endregion


		#region Events

		/// <summary>
		/// Event that triggers save
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			ArrayList eligibleForPrinting = new ArrayList();
			IEnumerator enu = this.tvOrders.Nodes.GetEnumerator();
			BOL.PatientUnitSelection pUS = null;
			//CR 2173
			Common.WorkloadProcessID workloadProcessID = Common.WorkloadProcessID.Unknown;
			bool eXMForBCE = false;

			while (enu.MoveNext())
			{
				//bool alreadyPrompted = false;
				System.Windows.Forms.TreeNode node = (TreeNode) enu.Current;
				if (node.Tag != null && node.Tag is BOL.PatientUnitSelection)
				{
					pUS = (BOL.PatientUnitSelection) node.Tag;

					// The user has to have either selected units in the current session or associate a
					// specimen with previously selected units.
					if (pUS.SelectedUnitsCollection.Count == 0)
					{						
						// BR_3.53
						// In cases where no new units were added, but an existing order was associated with a crossmatch, this
						// code ensures that the system will progress to XM.  This does not apply to Optional Crossmatch of OTHER
						if ((pUS.SpecimenIdentified) && (pUS.ValidSpecimenExists()))
						{
							foreach(DataRow dr in pUS.AlreadyOrderedUnits.Rows)
							{
								dr[Common.VbecsTables.OrderedUnit.CrossmatchRequiredIndicator] = true;
								// BR_3.37
								bool found = false;
								for (int i=0; i<_componentsNeedingCrossmatch.Count; i++)
								{
									if (pUS.OrderedComponent.CPRSOrderNumber == ((BOL.OrderedComponent) _componentsNeedingCrossmatch[i]).CPRSOrderNumber)
									{
										found = true;
										break;
									}
								}
								if (!found) _componentsNeedingCrossmatch.Add(pUS.OrderedComponent);
							}
						}
						else
						{
							continue;
						}
					}

					

					#region check exception report entries

					// The code must check to make sure that if all directed units were chosen, we're 
					// not triggering exception reports pertaining to 3.34.  This code is necassary for the for
					if (pUS.AllAutologousUnitsChosen())
					{
						if (pUS.AllDirectedUnitsChosen())
						{
							if (pUS.AllRestrictedUnitsChosen())
							{
								// remove all exception report entries 
								for (int i=0; i<_bloodUnitSelectionExceptions.Count; i++)
								{
									BOL.ExceptionReport eR = (BOL.ExceptionReport) _bloodUnitSelectionExceptions[i];
									if (eR.ExceptionType == Common.ExceptionType.Less_restrictive_unit_selected)
									{
										_bloodUnitSelectionExceptions.Remove(eR);
										i--;
									}
								}
							}
							else
							{
								// remove all exception report entries for restricted units
								for (int i=0; i<_bloodUnitSelectionExceptions.Count; i++)
								{
									BOL.ExceptionReport eR = (BOL.ExceptionReport) _bloodUnitSelectionExceptions[i];
									
									BloodUnit bloodUnit = new BOL.BloodUnit( (Guid) eR.ExceptionData[Common.VbecsTables.ExceptionUnitSelection.UnitGuid]);

									if (eR.ExceptionType == Common.ExceptionType.Less_restrictive_unit_selected &&
										bloodUnit.DirectedPatient.PatientGuid != Guid.Empty)
									{
										_bloodUnitSelectionExceptions.Remove(eR);
										i--;
									}
								}
							}
						}
						else
						{
							// remove all exception report entries for directed units
							for (int i=0; i<_bloodUnitSelectionExceptions.Count; i++)
							{
								BOL.ExceptionReport eR = (BOL.ExceptionReport) _bloodUnitSelectionExceptions[i];
								char donationTypeCode = new BOL.BloodUnit( (Guid) eR.ExceptionData[Common.VbecsTables.ExceptionUnitSelection.UnitGuid]).DonationType.DonationTypeCode;

								if (eR.ExceptionType == Common.ExceptionType.Less_restrictive_unit_selected &&
									BOL.BloodUnit.IsDirected(donationTypeCode))
								{
									_bloodUnitSelectionExceptions.Remove(eR);
									i--;
								}
							}
						}
					}

					// Here is a situation:
					// 1) User picks an expired unit.
					// 2) User gets warning, overrides it, and exception report entry created.
					// 3) Now, user changes selection date to BEFORE the unit expiration date.
					// The exception must be removed.  This code does that.  Comprende senor?
					foreach (BOL.BloodUnit bloodUnit in pUS.SelectedUnitsCollection)
					{
						DataRow dtRow = pUS.SelectedUnitsCollection.GetOrderedUnit(bloodUnit.BloodUnitGuid);
						DateTime selectedDate = (DateTime) dtRow[Common.VbecsTables.OrderedUnit.SelectedDate];

						if (bloodUnit.BloodUnitMedia.UnitExpirationDate > selectedDate)
						{
							foreach (BOL.ExceptionReport eR in _bloodUnitSelectionExceptions)
							{
								if ((Guid) eR.ExceptionData[Common.VbecsTables.ExceptionUnitSelection.UnitGuid] == bloodUnit.BloodUnitGuid &&
									eR.ExceptionType == Common.ExceptionType.Selected_expired_unit)
								{
									_bloodUnitSelectionExceptions.Remove(eR);
									break;
								}
							}
						}
					}
			
					#endregion


					//We're going to need to identify the exceptions for particular orders
					//otherwise we'll get an error because they may be created multiple times...
					ArrayList singleOrderExceptions = new ArrayList();


					// The purpose of this is to update the UnitStatusCode on blood units and to update Crossmatch information 
					// on OrderedUnits.  This is in the UI layer because the data depends on responses from the user.

					// Iterate through each of the Selected units to determine crossmatch and display appropriate messages
					foreach (BOL.BloodUnit bloodUnit in pUS.SelectedUnitsCollection)
					{
						//bloodUnit.BloodUnitStatus.UnitStatusCode = Common.UnitStatusCode.Assigned;
						// OrderedUnit (not to be confused with BloodUnit)
						DataRow dr = pUS.SelectedUnitsCollection.GetOrderedUnit(bloodUnit.BloodUnitGuid);

						foreach (BOL.ExceptionReport eR in _bloodUnitSelectionExceptions)
						{
							if ((Guid) eR.ExceptionData[Common.VbecsTables.ExceptionUnitSelection.UnitGuid] == bloodUnit.BloodUnitGuid)
							{
								singleOrderExceptions.Add(eR);
							}
						}
					
						// BR_3.07, BR_3.27
						if (pUS.OrderedComponent.ComponentOrdered.BloodComponentClassId == (int) Common.ComponentClass.RBC ||
							pUS.OrderedComponent.ComponentOrdered.BloodComponentClassId == (int) Common.ComponentClass.WB ||
							// BR_3.09
							pUS.OptionalCrossmatchOrdered(bloodUnit.BloodUnitGuid))
						{  	
							dr[Common.VbecsTables.OrderedUnit.CrossmatchRequiredIndicator] = true;

							// BR_3.18
							// if eXM is enabled (division, unit and patient), ask if they want it
							if (ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator && 
								ThisUser.CurrentDivisionRole.Division.ElectronicCrossmatchIndicator && 
								pUS.GetUnitEXMStatus(bloodUnit) && 
								pUS.OrderedComponent.Patient.ElectronicCrossmatchIndicator &&
								GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC003.EXM(bloodUnit.EyeReadableUnitId)) == DialogResult.Yes)
							{
								// BR_3.29
								dr[Common.VbecsTables.OrderedUnit.CrossmatchDate] = _currentDate;
								dr[Common.VbecsTables.OrderedUnit.CrossmatchResultCode] = Common.Utility.GetCrossmatchResultStringFromEnum(Common.CrossmatchResult.CompatibleEXM);
								dr[Common.VbecsTables.OrderedUnit.CrossmatchTechId] = Common.LogonUser.LogonUserName;
								eXMForBCE = true;
								//TODO: ask jensen ifthis is where workload should be collected.
								eligibleForPrinting.Add(bloodUnit);
							}
								// serologic crossmatch needed
							else
							{
								dr[Common.VbecsTables.OrderedUnit.CrossmatchRequiredIndicator] = true;
								// BR_3.18: Don't ask if they want to crossmatch unless a specimen exists (duh!)
								if (pUS.ValidSpecimenExists())
								{
									// BR_3.37
									bool found = false;
									for (int i=0; i<_componentsNeedingCrossmatch.Count; i++)
									{
										if (pUS.OrderedComponent.CPRSOrderNumber == ((BOL.OrderedComponent) _componentsNeedingCrossmatch[i]).CPRSOrderNumber)
										{
											found = true;
											break;
										}
									}
									if (!found) _componentsNeedingCrossmatch.Add(pUS.OrderedComponent);
								}
							}// else
						}// if specimen required
						else
						{
							dr[Common.VbecsTables.OrderedUnit.CrossmatchRequiredIndicator] = false;
							if (!bloodUnit.IsFrozen && pUS.OrderedComponent.SpecimenRequiredIndicator == false ||
								pUS.OrderedComponent.SpecimenRequiredIndicator == true && pUS.OrderedComponent.SpecimenIdentified && pUS.OrderedComponent.GetSpecimen().ABORhTested)  // CR3114
							{
								eligibleForPrinting.Add(bloodUnit);
							}
						}
					}// foreach
					//

					//Added by KD in order to send component order completion message to Vista
					Common.TaskStatus componentOrderStatusBeforeSave = Common.TaskStatus.Filled;
					Common.TaskStatus componentOrderStatusAfterSave;
					componentOrderStatusBeforeSave = BOL.OrderedComponent.GetStatusIncludingUnitsEligibleForIssue(pUS.OrderedComponent.OrderedComponentGuid);
					//Added by KD in order to send component order completion message to Vista
					//CR 2173
					
					DataTable dtBCEMessages = null;
					DataTable dtTempBCEMessages = null;

					foreach (BOL.BloodUnit bloodUnit in pUS.SelectedUnitsCollection)
					{
						//CR 2941
						//CR 2945
						//generate table with BCE_MESSAGE
						//The Unit is assigned here, send BCE message

						//CR 3015
						if (dtBCEMessages == null)
						{
							dtBCEMessages = OrderedUnit.UpdateBce(bloodUnit.BloodUnitGuid, this._patient.PatientGuid, pUS.OrderedComponent.OrderedComponentGuid, "", Common.HL7BPDispenseStatus.RS, eXMForBCE);
						}
						else
						{
							dtTempBCEMessages = OrderedUnit.UpdateBce(bloodUnit.BloodUnitGuid, this._patient.PatientGuid, pUS.OrderedComponent.OrderedComponentGuid, "", Common.HL7BPDispenseStatus.RS, eXMForBCE);
							if (dtTempBCEMessages.Rows.Count > 0)
								dtBCEMessages.Rows.Add(dtTempBCEMessages.Rows[0].ItemArray);
						}

						//BCE_MESSAGE end
					}

					if (!pUS.SelectedUnitsCollection.SaveUnits(Common.UpdateFunction.UC003FrmSelectUnitsForPatient, singleOrderExceptions, ref workloadProcessID, dtBCEMessages))
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.GeneralError("save.  No units were ordered."));
					}
					else
					{
						foreach (BOL.BloodUnit bloodUnit in pUS.SelectedUnitsCollection)
						{
							//CR2043 - Get the BloodUnitStatus lock, not bloodunit
							this.ReleaseLocks(this.GetBloodUnitStatusGuid(bloodUnit.BloodUnitGuid));
							if (eligibleForPrinting.Contains(bloodUnit))
								this.PrintTags(bloodUnit);						
						}

						//Added by KD in order to send component order completion message to Vista - BR_56.31, CR 2300
						if (componentOrderStatusBeforeSave != Common.TaskStatus.Filled)
						{
							componentOrderStatusAfterSave = BOL.OrderedComponent.GetStatusIncludingUnitsEligibleForIssue(pUS.OrderedComponent.OrderedComponentGuid);
							if (componentOrderStatusAfterSave == Common.TaskStatus.Filled)
							{
								BOL.OrderedComponent.SendComponentOrderCompletionMessageToVista(pUS.OrderedComponent.CPRSOrderNumber);
							}
						}					
						//Added by KD in order to send component order completion message to Vista
					}

				}// if
			}// while
			//CR 1441, CR 2173 same issue, yes CVS screwed up twice :(
			System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) workloadProcessID);
			if(dt!= null && workloadProcessID != Common.WorkloadProcessID.Unknown)
			{
				if(dt.Rows.Count == 0)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
				}
			}
			// We're done with thie patient, so release the locks and remove him/ her:
			System.Collections.ArrayList ocGuids = new ArrayList();
			foreach (BOL.OrderedComponent orderedComponent in this._orderedComponentsOnePatient)
			{
				ocGuids.Add(orderedComponent.OrderedComponentGuid);
			}

			_orderedComponentsAllPatients.Remove(_orderedComponentsOnePatient);
		
			this.ReleaseLocks((System.Guid[])ocGuids.ToArray(typeof(System.Guid)));

			_selectedUnits.Clear();
			
			// If there are more patients to select units for, populate form with their order information.
			// Otherwise, close form and be done with it!
			if (_orderedComponentsAllPatients.Count > 0)
			{
				_orderedComponentsOnePatient = (ArrayList) _orderedComponentsAllPatients[0];
				PopulateForm();
			}
			else
			{
				if (_componentsNeedingCrossmatch.Count>0 && GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC003.XM()) != DialogResult.Yes)
				{
					_componentsNeedingCrossmatch.Clear();
				}
				if (_orderedTests.Count > 0 || _componentsNeedingCrossmatch.Count > 0)
				{
					//Since 92-3-56 is a rare case, we unlock, then let 56 lock again
					this.UnlockAllRecords();
					DlgSelectTestingRack dlg = new DlgSelectTestingRack(_orderedTests, _componentsNeedingCrossmatch, this.MdiParent, _expiredOrderExceptions);
					if (dlg.DialogResult != DialogResult.Abort)
					{
						dlg.MdiParent = this.MdiParent;
						dlg.Show();
					}
				}
				//Setting the dirty variable to false so that when the form
				//is closing that the user will not be prompted about unsaved data
				//because the data is already saved.
				this.IsDirty=false;
				this.Close();
			}
		}

		/// <summary>
		/// tvOrders_AfterSelect
		/// BR_3.53
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void tvOrders_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			this.bloodUnitSelectorVertical1.ClearBloodUnit();
			
			this.dtpAssignedDate.Enabled = false;
			this.cmbAssignedBy.Enabled = false;

			_currentlySelectedNode = this.tvOrders.SelectedNode;
			this.txtExpires.Text = String.Empty;
			
			// if Ordered Component
			if (_currentlySelectedNode.Parent == null)
			{
				this.txtUnitEXMStatus.Text = _currentlySelectedPUS.GetDivisionAndPatientEXMStatus(ThisUser.CurrentDivisionRole.Division);
				_currentlySelectedPUS = (BOL.PatientUnitSelection) this.tvOrders.SelectedNode.Tag;

				if (_currentlySelectedPUS.OrderedComponent.SpecimenIdentified)  // CR3114
				{
					this.patientSpecimenDisplayPanel1.SpecimenID	= _currentlySelectedPUS.OrderedComponent.GetSpecimen().SpecimenUid;  // CR3114
					this.patientSpecimenDisplayPanel1.Expires		= Common.VBECSDateTime.FormatDateTimeString(_currentlySelectedPUS.OrderedComponent.GetSpecimen().SpecimenExpirationDate);  // CR3114
				}
				else
				{
					this.patientSpecimenDisplayPanel1.SpecimenID	= string.Empty;
					this.patientSpecimenDisplayPanel1.Expires		= string.Empty;
				}

				this.SetEmergencyIssue(_currentlySelectedPUS.IsEmergencyIssue);
				// Setting the IsDirtyChanged event to fire the SetDirtyFlag function
				// Everytime a property of the variable is altered and thus the form
				// has been changed in one way or another.
				_currentlySelectedPUS.IsDirtyChanged+=new System.EventHandler(this.SetDirtyFlag);

				// this is the parent node, so dusplay/populate the components screen
				this.pnlUnit.Visible = false;
				this.pnlOrder.Visible = true;
				
				// Populate the orderedComponent panel.
				OrderedComponent orderedComponent = _currentlySelectedPUS.OrderedComponent;
				this.txtComponentClass.Text = orderedComponent.ComponentOrdered.BloodComponentName.Trim();
				this.txtQty.Text			= orderedComponent.Quantity.ToString().Trim();
				this.txtComments.Text		= orderedComponent.OrderedComponentComments.Trim();
				this.txtUrgency.Text		= orderedComponent.OrderUrgencyText.Trim();
				this.txtSpecialRequirements.Text = orderedComponent.OrderSpecialInstructions.Trim();
				this.txtDateOrdered.Text	= Common.VBECSDateTime.FormatDateTimeString(orderedComponent.OrderReceivedDateTime);
				this.txtOrderedBy.Text		= orderedComponent.OrderingProviderLastName.Trim() + ", " + orderedComponent.OrderingProviderFirstName.Trim();
				this.txtDateWanted.Text		= Common.VBECSDateTime.FormatDateTimeString(orderedComponent.RequiredDateTime);
				this.txtSurgery.Text		= orderedComponent.SurgeryName.Trim();
				this.txtReasonRequested.Text= orderedComponent.RequestReason.Trim();

				this.btnDeselect.EnabledButton = false;
				this.btnDeselect.Visible = false;
				this.btnSelectUnit.EnabledButton = true;
				this.btnSelectUnit.Visible = false;
			}
				// if subnode (blood unit)
			else
			{
				this.bloodUnitSelectorVertical1.txtUnitID.ReadOnly = true;
				this.bloodUnitSelectorVertical1.txtProductID.ReadOnly = true;
				_currentlySelectedPUS = (BOL.PatientUnitSelection) this.tvOrders.SelectedNode.Parent.Tag;

				if (_currentlySelectedPUS.OrderedComponent.SpecimenIdentified)  // CR3114
				{
					this.patientSpecimenDisplayPanel1.SpecimenID	= _currentlySelectedPUS.OrderedComponent.GetSpecimen().SpecimenUid;  // CR3114
					this.patientSpecimenDisplayPanel1.Expires		= Common.VBECSDateTime.FormatDateTimeString(_currentlySelectedPUS.OrderedComponent.GetSpecimen().SpecimenExpirationDate);  // CR3114
				}
				else
				{
					this.patientSpecimenDisplayPanel1.SpecimenID	= string.Empty;
					this.patientSpecimenDisplayPanel1.Expires		= string.Empty;
				}

				//Setting the IsDirtyChanged event to fire the SetDirtyFlag function
				//everytime a property of the variable is altered and thus the form
				//has been changed in one way or another.
				_currentlySelectedPUS.IsDirtyChanged += new System.EventHandler(this.SetDirtyFlag);
				this.pnlOrder.Visible = false;
				this.pnlUnit.Visible = true;
				this.btnDeselect.EnabledButton = true;
				this.btnDeselect.Visible = true;
				this.btnDeselect.Text = "&Remove Unit";
				this.btnSelectUnit.EnabledButton = false;
				this.btnSelectUnit.Visible = false;

				Guid bloodUnitGuid = (Guid) this._currentlySelectedNode.Tag;

				BOL.BloodUnit bloodUnit = new BOL.BloodUnit(bloodUnitGuid);
				// set expiration 
				this.txtExpires.Text = _currentlySelectedPUS.GetTimeUntilExpiration(bloodUnit);

				this.bloodUnitSelectorVertical1.DisplayBloodUnit(bloodUnit);
				this.bloodUnitDetailsTab1.BloodUnit = bloodUnit;

				// optional crossmatch processing
				if (_currentlySelectedPUS.OptionalCrossmatchOrdered(bloodUnitGuid) ||
					_currentlySelectedPUS.SpecimenIdentified)
				{
					this.cbCrossmatchComponent.Checked = true;
					this.btnSpecimenSearch.Enabled = true;
					// The same specimen will be used for every optional crossmatch ordered
					if (_currentlySelectedPUS.OrderedComponent.SpecimenIdentified)  // CR3114
					{
						this.txtSpecimenUID.Text = _currentlySelectedPUS.OrderedComponent.GetSpecimen().SpecimenUid;  // CR3114
					}
					else
					{
						this.txtSpecimenUID.Text = String.Empty;
						this.errError.SetVbecsError(this.btnSpecimenSearch, Common.StrRes.Tooltips.UC016.SpecimenUIDRequired().ResString); // **** 508 Compliance ***
					}
				}
				else
				{
					this.cbCrossmatchComponent.Checked = false;
					this.btnSpecimenSearch.Enabled = false;
					this.txtSpecimenUID.Text = string.Empty;
					this.txtSpecimenExpires.Text = string.Empty;
					this.errError.SetVbecsError(txtSpecimenUID, String.Empty); // **** 508 Compliance ***
				}

				this.btnSelectUnit.Visible = false;
				this.btnDeselect.Visible = true;

				// Call to BR_3.09
				// Can only allow the optional crossmatch if the unit was chosen in the 
				// current session
				if ((_currentlySelectedPUS.DisplayOptionalCrossmatch(bloodUnit) && 
					!_currentlySelectedPUS.AlreadySelectedInPreviousSession(bloodUnitGuid)) 
					||
					// BR_3.53 - if specimen required, but none present, allow user to 
					// associate a specimen
					(_currentlySelectedPUS.OrderedComponent.SpecimenRequiredIndicator &&
					_currentlySelectedPUS.OrderedComponent.SpecimenIdentified == false))  // CR3114
				{
					this.grpUnitXMStatus.Visible = false;
					this.grpCrossmatchIndicator.Visible = true;
					if (_currentlySelectedPUS.OrderedComponent.SpecimenRequiredIndicator)
					{
						this.cbCrossmatchComponent.Text = "Associate with Specimen";
					}
					else
					{
						this.cbCrossmatchComponent.Text = "Optional Component Crossmatch";
					}
				}
				else
				{
					// Call to BR_3.17, 3.18
					if (_patient.ElectronicCrossmatchIndicator)
					{
						this.txtUnitEXMStatus.Text = _currentlySelectedPUS.GetUnitEXMStatusText(bloodUnit);
					}
					this.grpCrossmatchIndicator.Visible = false;
					this.grpUnitXMStatus.Visible = true;
				}
				this.SetTimeAndTech(bloodUnitGuid);
			}
		}


		/// <summary>
		/// btnDeselect_Click
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnDeselect_Click(object sender, System.EventArgs e)
		{
			Guid bloodUnitGuid = (Guid) this._currentlySelectedNode.Tag;
			// remove from collection and TreeView
			try
			{
				if (!SelectionOrderValid(bloodUnitGuid))
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC073.SelectionOrderInvalid());
				}
				else
				{
					_currentlySelectedPUS.SelectedUnitsCollection.RemoveUnit(bloodUnitGuid);
					
					
					this.grpUnitXMStatus.Visible = true;
					this.grpCrossmatchIndicator.Visible = false;

					this.tvOrders.Nodes.Remove(_currentlySelectedNode);
					_selectedUnits.Remove(bloodUnitGuid);

					// reset specimen fields
					this.cbCrossmatchComponent.Checked = false;
					this.txtSpecimenUID.Text = string.Empty;
					this.txtSpecimenExpires.Text = string.Empty;
				
					RemoveExceptions(bloodUnitGuid);
					//CR2043 - Get the BloodUnitStatus guid, not BloodUnit
					this.ReleaseLocks(this.GetBloodUnitStatusGuid(bloodUnitGuid));
				}
			}
			catch(BOL.BusinessObjectException)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC003.InvalidUnitRemoval());
			}
		}

		/// <summary>
		/// SelectionOrderValid
		/// </summary>
		/// <param name="bloodUnitGuid"></param>
		/// <returns></returns>
		private bool SelectionOrderValid(Guid bloodUnitGuid)
		{
			BOL.BloodUnit deselectedUnit = new BOL.BloodUnit(bloodUnitGuid);
			if (!BOL.BloodUnit.IsAutologous(deselectedUnit.DonationType.DonationTypeCode) && 
				!BOL.BloodUnit.IsDirected(deselectedUnit.DonationType.DonationTypeCode) &&
				deselectedUnit.DirectedPatient.PatientGuid == Guid.Empty) 
			{
				return true;
			}
				// if the removed unit is autologous, make sure there are no units currently selected
				// that are less than autologous
			else if (BOL.BloodUnit.IsAutologous(deselectedUnit.DonationType.DonationTypeCode))
			{
				foreach (BOL.BloodUnit bloodUnit in _currentlySelectedPUS.SelectedUnitsCollection)
				{
					if (deselectedUnit.BloodUnitGuid != bloodUnit.BloodUnitGuid &&
						!BOL.BloodUnit.IsAutologous(bloodUnit.DonationType.DonationTypeCode) &&
						!ExceptionRecorded(bloodUnit.BloodUnitGuid))
					{
						return false;
					}
				}
			}
				// if the removed unit is directed, make sure there are no units currently selected
				// that are less than directed
			else if (BOL.BloodUnit.IsDirected(deselectedUnit.DonationType.DonationTypeCode))
			{
				foreach (BOL.BloodUnit bloodUnit in _currentlySelectedPUS.SelectedUnitsCollection)
				{
					if (deselectedUnit.BloodUnitGuid != bloodUnit.BloodUnitGuid &&
						!BOL.BloodUnit.IsAutologous(bloodUnit.DonationType.DonationTypeCode) &&
						!BOL.BloodUnit.IsDirected(bloodUnit.DonationType.DonationTypeCode) &&
						!ExceptionRecorded(bloodUnit.BloodUnitGuid))
					{
						return false;
					}
				}
			}
				// Transfusion Only: If the removed unit is restricted, make sure there are no
				// allogeneic units
			else if (deselectedUnit.DirectedPatient.PatientGuid != Guid.Empty)
			{
				foreach (BOL.BloodUnit bloodUnit in _currentlySelectedPUS.SelectedUnitsCollection)
				{
					if (deselectedUnit.BloodUnitGuid != bloodUnit.BloodUnitGuid &&
						!BOL.BloodUnit.IsAutologous(bloodUnit.DonationType.DonationTypeCode) &&
						!BOL.BloodUnit.IsDirected(bloodUnit.DonationType.DonationTypeCode) &&
						bloodUnit.DirectedPatient.PatientGuid == Guid.Empty &&
						!ExceptionRecorded(bloodUnit.BloodUnitGuid))
					{
						return false;
					}
				}
			}
			return true;
		}

		/// <summary>
		/// Returns a boolean value indicating if a unit has an exception recorded for selecting
		/// units out of order.
		/// </summary>
		/// <param name="bloodUnitGuid"></param>
		/// <returns></returns>
		private bool ExceptionRecorded(Guid bloodUnitGuid)
		{
			// remove all exception report entries 
			for (int i=0; i<_bloodUnitSelectionExceptions.Count; i++)
			{
				BOL.ExceptionReport eR = (BOL.ExceptionReport) _bloodUnitSelectionExceptions[i];
				if (eR.ExceptionType == Common.ExceptionType.Less_restrictive_unit_selected &&
					(Guid) eR.ExceptionData[Common.VbecsTables.ExceptionUnitSelection.UnitGuid] == bloodUnitGuid)
				{
					return true;
				}
			}
			return false;
		}

		/// <summary>
		/// Exceptions are generated when the unit is first selected, so they need to be
		/// delected with the unit is released.
		/// </summary>
		/// <param name="bloodUnitGuid"></param>
		private void RemoveExceptions(Guid bloodUnitGuid)
		{
			ArrayList removeExc = new ArrayList();
			for (int i=0; i<_bloodUnitSelectionExceptions.Count; i++)
			{
				BOL.ExceptionReport excRep = (BOL.ExceptionReport) _bloodUnitSelectionExceptions[i];
				if ( (Guid) excRep.ExceptionData[Common.VbecsTables.ExceptionUnitSelection.UnitGuid] == bloodUnitGuid)
				{
					removeExc.Add(excRep);
				}	
			}

			for (int j=0; j<removeExc.Count; j++)
			{
				BOL.ExceptionReport excRep = (BOL.ExceptionReport) removeExc[j];
				_bloodUnitSelectionExceptions.Remove(excRep);
			}
		}

	
		/// <summary>
		/// bloodUnitSelectorVertical1_SelectBtnClick
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void bloodUnitSelectorVertical1_SelectBtnClick(object sender, System.EventArgs e)
		{
			BloodUnit bloodUnit = new BloodUnit(this.bloodUnitSelectorVertical1.SelectedBloodUnit.BloodUnitGuid);
			this.AddUnit(bloodUnit, false); 
			this.bloodUnitSelectorVertical1_ClearBtnClick(null, System.EventArgs.Empty);
		}


		/// <summary>
		/// bloodUnitSelectorVertical1_SearchClick
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void bloodUnitSelectorVertical1_SearchClick(object sender, System.EventArgs e)
		{
			_dtAvailableUnits = _currentlySelectedPUS.GetCompatibleUnitsForDisplay();
			if(_dtAvailableUnits == null || _dtAvailableUnits.Rows.Count == 0)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC003.NoMatchingUnits());
			}
			else
			{
				
				DlgSelectBloodUnits dlg = new DlgSelectBloodUnits(_dtAvailableUnits, this.bloodUnitSelectorVertical1.EnteredEyeReadableUnitId, this.bloodUnitSelectorVertical1.EnteredUnitProductCode);
				dlg.MultiSelect = true;
				dlg.TitleBarText = "VBECS - Select Units";
				dlg.LogoBarText = "Select Units";

                dlg.ShowDialogFromLockedParent(this, false);				
				if (dlg.DialogResult == DialogResult.OK)
				{
					this.AddUnitsToTreeView(dlg.SelectedUnits);
				}
			}
		}

		/// <summary>
		/// btnAddUnits_Click
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnAddUnits_Click(object sender, System.EventArgs e)
		{
			// BR_3.25, 3.31, 3.34, 3.38, 16.10, 16.12, 16.13
			if (_currentlySelectedPUS.DirectedBloodUnits.Rows.Count > 0 && !_alreadyOpened.Contains(_currentlySelectedPUS.OrderedComponent.CPRSOrderNumber))
			{
				DlgSelectDirectedUnits dlg = new DlgSelectDirectedUnits(_currentlySelectedPUS.OrderedComponent.Patient.PatientGuid, _currentlySelectedPUS.DirectedBloodUnits);
				dlg.ValidateUnitsChosenCorrectly = true;

                dlg.ShowDialogFromLockedParent(this, true);
                if (dlg.DidLocksExpire) return;

				if (dlg.DialogResult == DialogResult.OK)
				{
					this.AddUnitsToTreeView(dlg.SelectedUnits);
				}
				else
				{
					dlg.CancelLocks();
				}

                //CR3480 - if the Lock exires on an override window, _alreadyOpened = null, meh fix, but simplest
                if (_alreadyOpened != null)
				    _alreadyOpened.Add(_currentlySelectedPUS.OrderedComponent.CPRSOrderNumber);
			}
			else
			{
				this.bloodUnitSelectorVertical1_ClearBtnClick(sender,e);
				// Reset so the AfterSelect event gets fired properly.
				this.tvOrders.SelectedNode = null;

				this.pnlOrder.Visible = false;
				this.pnlUnit.Visible = true;
			}
			this.bloodUnitSelectorVertical1.Focus();
		}

		/// <summary>
		/// Display the details of the order.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOrderDetails_Click(object sender, System.EventArgs e)
		{
			DlgOrderDetails dlg = new DlgOrderDetails(_currentlySelectedPUS.OrderedComponent);

            dlg.ShowDialogFromLockedParent(this, false);
		}

		/// <summary>
		/// patientSpecimenDisplayPanel1_SIAndTRClick
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void patientSpecimenDisplayPanel1_SIAndTRClick(object sender, System.EventArgs e)
		{
			DlgDisplayTransReqsAndSpecIns dlg = new DlgDisplayTransReqsAndSpecIns(_currentlySelectedPUS.OrderedComponent.Patient);
			if (dlg.DialogResult != DialogResult.Abort)
			{
                dlg.ShowDialogFromLockedParent(this, false);
			}
			else
			{
				dlg.Dispose();
			}
		}

		/// <summary>
		/// btnCancel_Click
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// cbCrossmatchComponent_Click
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cbCrossmatchComponent_Click(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = false;
			this.ttToolTip.SetToolTip(this.btnOK, "A specimen must be identified");

			if (this.cbCrossmatchComponent.Checked == true)
			{
				this.btnSpecimenSearch.Enabled = true;
				// ToDo: Rewrite this when confirmed changes work
				if (_currentlySelectedPUS.OrderedComponent.SpecimenRequiredIndicator)
				{
					_currentlySelectedPUS.SpecimenIdentified = true;
				}
				else
				{
					_currentlySelectedPUS.AddOptionalCrossmatch(this.bloodUnitSelectorVertical1.SelectedBloodUnit.BloodUnitGuid);
				}
				
				if (_currentlySelectedPUS.OrderedComponent.SpecimenIdentified == false)  // CR3114
				{
					this.txtSpecimenUID.Enabled = true;
					this.errError.SetVbecsError(this.btnSpecimenSearch, Common.StrRes.Tooltips.UC016.SpecimenUIDRequired().ResString); // **** 508 Compliance ***
				}
				else
				{
					this.txtSpecimenUID.Enabled = false;
					this.txtSpecimenUID.Text = _currentlySelectedPUS.OrderedComponent.GetSpecimen().SpecimenUid;  // CR3114
				}
			}
			else
			{				
				this.btnSpecimenSearch.Enabled = false;
				if (_currentlySelectedPUS.OrderedComponent.SpecimenRequiredIndicator)
				{
					_currentlySelectedPUS.SpecimenIdentified = false;
					_currentlySelectedPUS.OrderedComponent.AssociateWithSpecimen(null);  // CR3114
				}
				else
				{
					_currentlySelectedPUS.RemoveOptionalCrossmatch(this.bloodUnitSelectorVertical1.SelectedBloodUnit.BloodUnitGuid);
				}

				this.txtSpecimenUID.Text = string.Empty;
				this.txtSpecimenUID.Enabled = false;
				this.txtSpecimenExpires.Text = string.Empty;
				this.errError.SetVbecsError(this.btnSpecimenSearch, string.Empty); // **** 508 Compliance ***
				this.btnOK.EnabledButton = true;
				this.ttToolTip.SetToolTip(this.btnOK, string.Empty);
			}
		}

		/// <summary>
		/// txtSpecimenUID_TextChanged Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		/// CR2877: deleted the check for a specimen UID of 10
		private void txtSpecimenUID_TextChanged(object sender, System.EventArgs e)
		{
			string uid = this.txtSpecimenUID.Text.Trim();
			
			if (this.cbCrossmatchComponent.Checked == true)
			{
				this.btnOK.EnabledButton = false;
				this.ttToolTip.SetToolTip(this.btnOK, "There is a problem with the specimen");

				
				BOL.Specimen specimen = new  BOL.Specimen(uid);
				this.txtSpecimenExpires.Text = specimen.SpecimenExpirationDate.ToString();

				if (!specimen.IsNew && specimen.Patient.PatientGuid == _patient.PatientGuid)
				{
					if (!specimen.UnacceptableSpecimenIndicator)
					{
						if (specimen.MaintainableSpecimenIndicator)
						{
							// must get the bloodunitGuid
							if (specimen.SpecimenExpirationDate > (DateTime) _currentlySelectedPUS.SelectedUnitsCollection.GetOrderedUnit(this.bloodUnitSelectorVertical1.SelectedBloodUnit.BloodUnitGuid)[Common.VbecsTables.OrderedUnit.SelectedDate])
							{
								// Everything is OK!!
								_currentlySelectedPUS.OrderedComponent.AssociateWithSpecimen(specimen);  // CR3114
								this.btnOK.EnabledButton = true;
								this.errError.SetVbecsError(this.btnSpecimenSearch, String.Empty); // **** 508 Compliance ***
							}
							else
							{
								this.errError.SetVbecsError(this.btnSpecimenSearch, Common.StrRes.InfoMsg.UC043.SpecimenExpired().ResString); // **** 508 Compliance ***
							}
						}
						else
						{
							this.errError.SetVbecsError(this.btnSpecimenSearch, Common.StrRes.SysErrMsg.UC035.NonMaintainableSpecimen().ResString); // **** 508 Compliance ***
						}
					}
					else
					{
						this.errError.SetVbecsError(this.btnSpecimenSearch, Common.StrRes.InfoMsg.UC035.UnacceptableSpecimenNotAllowed().ResString); // **** 508 Compliance ***
					}
					}
				else
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC016.WrongSpecimen());
					this.errError.SetVbecsError(this.btnSpecimenSearch, Common.StrRes.InfoMsg.UC016.WrongSpecimen().ResString); // **** 508 Compliance ***
				}
			}
		}

		/// <summary>
		/// dtpAssignedDate_Leave
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dtpAssignedDate_Leave(object sender, System.EventArgs e)
		{
			if(!_isLoading)
			{
				if (this.bloodUnitSelectorVertical1.SelectedBloodUnit != null)
				{
					Guid bloodUnitGuid = (Guid) this.bloodUnitSelectorVertical1.SelectedBloodUnit.BloodUnitGuid;
					if (!_currentlySelectedPUS.AlreadySelectedInPreviousSession(bloodUnitGuid))
					{
						DataRow dtRow = _currentlySelectedPUS.SelectedUnitsCollection.GetOrderedUnit(bloodUnitGuid);
						if (dtRow != null) dtRow[Common.VbecsTables.OrderedUnit.SelectedDate] = dtpAssignedDate.Value;
					}
				}
			}
		}

		/// <summary>
		/// dtpAssignedDate_ValueChanged
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dtpAssignedDate_ValueChanged(object sender, System.EventArgs e)
		{
			if(!_isLoading)
			{
				Guid bloodUnitGuid = (Guid) this.bloodUnitSelectorVertical1.SelectedBloodUnit.BloodUnitGuid;
				if (!_currentlySelectedPUS.AlreadySelectedInPreviousSession(bloodUnitGuid))
				{
					DataRow dtRow = _currentlySelectedPUS.SelectedUnitsCollection.GetOrderedUnit(bloodUnitGuid);
					if (dtRow != null) dtRow[Common.VbecsTables.OrderedUnit.SelectedDate] = dtpAssignedDate.Value;
				}
			}
		}

		private void cmbAssignedBy_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(!_isLoading)
			{	
				if (cmbAssignedBy.SelectedIndex != -1)
				{
					Guid bloodUnitGuid = (Guid) this.bloodUnitSelectorVertical1.SelectedBloodUnit.BloodUnitGuid;
					DataRow dtRow = _currentlySelectedPUS.SelectedUnitsCollection.GetOrderedUnit(bloodUnitGuid);
					if (dtRow != null) dtRow[Common.VbecsTables.OrderedUnit.SelectedTechId] = ((BOL.VbecsUser) _users[this.cmbAssignedBy.SelectedIndex]).UserNTLoginID;
				}
				else
				{
					this.cmbAssignedBy.SelectedItem = ThisUser.UserName;
				}
			}
		}

		private void bloodUnitSelectorVertical1_ClearBtnClick(object sender, System.EventArgs e)
		{
            if (!this.bloodUnitSelectorVertical1.IsDisposed)     //CR3480 - another meh workaround - the control & form will be disposed if the locks expired
            {
                this.errError.SetVbecsError(this.bloodUnitSelectorVertical1.txtProductID, String.Empty); // **** 508 Compliance ***
                //
                this.bloodUnitSelectorVertical1.ClearBloodUnit();
                this.bloodUnitSelectorVertical1.txtProductID.ReadOnly = false;
                this.bloodUnitSelectorVertical1.txtUnitID.ReadOnly = false;
                this.bloodUnitDetailsTab1.BloodUnit = null;
                this.btnSelectUnit.Visible = true;
                this.btnSelectUnit.EnabledButton = false;
                this.btnDeselect.Visible = false;
                this.btnDeselect.EnabledButton = false;

                this.dtpAssignedDate.Enabled = false;
                this.cmbAssignedBy.Enabled = false;
            }
		}

		private void bloodUnitSelectorVertical1_UnitUpdated(object sender, System.EventArgs e)
		{
			this.bloodUnitDetailsTab1.BloodUnit = this.bloodUnitSelectorVertical1.SelectedBloodUnit;
			this.SetTimeAndTech(this.bloodUnitSelectorVertical1.SelectedBloodUnit.BloodUnitGuid);
			this.bloodUnitSelectorVertical1.txtProductID.ReadOnly = true;
			this.bloodUnitSelectorVertical1.txtUnitID.ReadOnly = true;
		}


		private void btnSpecimenSearch_Click(object sender, System.EventArgs e)
		{
			DlgSpecimenSearch dlg = new DlgSpecimenSearch(_patient);

			dlg.ShowDialogFromLockedParent(this, false);
			if (dlg.DialogResult == DialogResult.OK)
			{
				this.txtSpecimenUID.Text = dlg.SpecimenUid;
			}
		}

		/// <summary>
		/// Free up resources
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmSelectUnitsForPatient_Closed(object sender, EventArgs e)
		{
			if(this._patient != null)
			{
				this._patient.AboRh.Dispose();
				this._patient.AboRHHistory.Dispose();
				this._patient.Dispose();
			}

			// This is an ArrayList of ArrayLists.  The "outer" ArrayList (this one) contains 
			// ArrayLists of OrderedComponents.  Each "inner" ArrayList has components 
			// associated with one patient.
			if(this._orderedComponentsAllPatients != null)
			{
				for (int i = 0; i < this._orderedComponentsAllPatients.Count; i++)
				{
					ArrayList innerList = (ArrayList)this._orderedComponentsAllPatients[i];
					//
					for (int j = 0; j < innerList.Count; j++)
					{
						if( innerList[j] is BOL.OrderedComponent )
						{
							((BOL.OrderedComponent)innerList[j]).Patient.AboRh.Dispose();
							((BOL.OrderedComponent)innerList[j]).Patient.Dispose();
							((BOL.OrderedComponent)innerList[j]).Dispose();
						}
					}
					innerList = null;
				}
				this._orderedComponentsAllPatients = null;
			}
		
			// This contains all of the ordered components for the patient currently being operated on.
			if(this._orderedComponentsOnePatient != null)
			{
				for (int i = 0; i < this._orderedComponentsOnePatient.Count; i++)
				{
					if( this._orderedComponentsOnePatient[i] is BOL.OrderedComponent )
					{
						((BOL.OrderedComponent)this._orderedComponentsOnePatient[i]).Patient.AboRh.Dispose();
						((BOL.OrderedComponent)this._orderedComponentsOnePatient[i]).Patient.Dispose();
						((BOL.OrderedComponent)this._orderedComponentsOnePatient[i]).Dispose();
					}
				}
				this._orderedComponentsOnePatient = null;
			}
			
			// This contains the node currently being operated on.
			if(this._currentlySelectedNode != null)
			{
				for (int i = 0; i < this._currentlySelectedNode.Nodes.Count; i++)
				{
					if (this._currentlySelectedNode.Nodes[i].Tag != null && this._currentlySelectedNode.Nodes[i].Tag is BOL.PatientUnitSelection)
					{
						((BOL.PatientUnitSelection)this._currentlySelectedNode.Nodes[i].Tag).ClearClassObjects();
					}
					this._currentlySelectedNode.Nodes[i].Tag = null;
				}
				this._currentlySelectedNode = null;
			}

			// This contains the PatientUnitSelection currently being operated on.
			if(this._currentlySelectedPUS != null)
			{
				this._currentlySelectedPUS.ClearClassObjects();
				this._currentlySelectedPUS = null;
			}
			
			// Available units for the patient (pass to UC05 for unit selection).
			this._dtAvailableUnits = null;

			// Ordered Tests; this UC does nothing with this; just passes it on to UC53
			if(this._orderedTests != null)
			{
				for (int i = 0; i < this._orderedTests.Count; i++)
				{
					if( this._orderedTests[i] is BOL.OrderedComponent )
					{
						((BOL.OrderedTest)this._orderedTests[i]).Patient.AboRh.Dispose();
						((BOL.OrderedTest)this._orderedTests[i]).Patient.Dispose();
						((BOL.OrderedTest)this._orderedTests[i]).Dispose();
					}
				}
				this._orderedTests = null;
			}
			
			// Components containing units that require a crossmatch; pass this to UC53
			if(this._componentsNeedingCrossmatch != null)
			{
				for (int i = 0; i < this._componentsNeedingCrossmatch.Count; i++)
				{
					if( this._componentsNeedingCrossmatch[i] is BOL.OrderedComponent )
					{
						((BOL.OrderedComponent)this._componentsNeedingCrossmatch[i]).Patient.AboRh.Dispose();
						((BOL.OrderedComponent)this._componentsNeedingCrossmatch[i]).Patient.Dispose();
						((BOL.OrderedComponent)this._componentsNeedingCrossmatch[i]).Dispose();
					}
				}
				this._componentsNeedingCrossmatch = null;
			}
				
			// This holds units that have already been assigned to a patient
			this._dtPreviouslyOrderedUnits = null;
				
			// Keeps track of units selected in the current session so they aren't selected
			// twice for the same patient.
			if(this._selectedUnits != null)
			{
				for (int i = 0; i < this._selectedUnits.Count; i++)
				{
					if( this._selectedUnits[i] is BOL.BloodUnit )
					{
						((BOL.BloodUnit)this._selectedUnits[i]).Dispose();
					}
				}
				this._selectedUnits = null;
			}
				
			// Assigning users
			if(this._users != null)
			{
				for (int i = 0; i < this._users.Count; i++)
				{
					if( this._users[i] is BOL.VbecsUser )
					{
						((BOL.VbecsUser)this._users[i]).Dispose();
					}
				}
				this._users = null;
			}
				
			// The first time the Add Units button is clicked to add units to the order, 
			// all directed units are to be displayed.  This keeps track of this. 
			if(this._alreadyOpened != null)
			{
				for (int i = 0; i < this._alreadyOpened.Count; i++)
				{
					this._alreadyOpened[i] = null;
				}
				this._alreadyOpened = null;
			}
				
			// Holds exception report entries
			if(this._bloodUnitSelectionExceptions != null)
			{
				for (int i = 0; i < this._bloodUnitSelectionExceptions.Count; i++)
				{
					this._bloodUnitSelectionExceptions[i] = null;
				}
				this._bloodUnitSelectionExceptions = null;
			}
				
			// **********************************************************************************************************

			if(this.tvOrders != null)
			{
				this.tvOrders.Tag = null;
				this.tvOrders.Dispose();
			}

			if(this.patientSpecimenDisplayPanel1.PatientInfoToolbar != null && this.patientSpecimenDisplayPanel1.PatientInfoToolbar.Patient != null)
			{
				this.patientSpecimenDisplayPanel1.PatientInfoToolbar.Patient.AboRh.Dispose();
				this.patientSpecimenDisplayPanel1.PatientInfoToolbar.Patient.Dispose();
				this.patientSpecimenDisplayPanel1.PatientInfoToolbar.Parent = null;
				this.patientSpecimenDisplayPanel1.PatientInfoToolbar.Dispose();
			}

			if(this.vbecsLogo1 != null)
			{
				this.vbecsLogo1.Parent = null;
				this.vbecsLogo1.Dispose();
			}

			if(this.btnOK != null)
			{
				this.btnOK.Parent = null;
				this.btnOK.Dispose();
			}
			
			if(this.bloodUnitDetailsTab1 != null)
			{
				if(this.bloodUnitDetailsTab1.BloodUnit != null)
				{
					this.bloodUnitDetailsTab1.BloodUnit.Dispose();
				}
				this.bloodUnitDetailsTab1.Dispose();
			}

			if(this.bloodUnitSelectorVertical1 != null)
			{
				this.bloodUnitSelectorVertical1.ClearControlData();
				this.bloodUnitSelectorVertical1.Dispose();
			}

			if(this.cmbAssignedBy != null)
			{
				this.cmbAssignedBy.Parent = null;
				this.cmbAssignedBy.Dispose();
			}

			DestructComponent();
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmSelectUnitsForPatient_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.btnOK.EnabledButton == false)
			{
				textToSpeak = this.ttToolTip.GetToolTip(btnOK);
			}

			if (this.btnDeselect.EnabledButton == false)
			{
				if (textToSpeak != "")
					textToSpeak += "\n";
				textToSpeak += this.ttToolTip.GetToolTip(btnDeselect);
			}

			if (textToSpeak != "")
				textToSpeak += "\n";
			textToSpeak += this.bloodUnitSelectorVertical1.GetErrorMessages();

			if(this.patientSpecimenDisplayPanel1.Visible)
			{
				if (textToSpeak != "")
					textToSpeak += "\n";
				textToSpeak += this.patientSpecimenDisplayPanel1.GetErrorMessagesFor508();
			}
			this.SpeakMessage( textToSpeak );
		}

		#endregion

		

	}
}
